<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class CTA extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Call to Action', 'fmwave-core' );
		$this->rt_base = 'rt-cta';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(		
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
            'type'    => Controls_Manager::CHOOSE,
            'id'      => 'icon-alignment',
            'label'   => esc_html__( 'Align Style', 'fmwave-core' ),
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'fmwave-core' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'fmwave-core' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'fmwave-core' ),
                        'icon' => 'fa fa-align-right',
                    ],                   
                ],
				'selectors' => array(
					'{{WRAPPER}} .banner-section' => 'text-align: {{VALUE}}',
				),
             'default' => 'left',
            ),

			array(
				'mode' => 'section_end',
			),	

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_content',
				'label'   => esc_html__( 'Title / Content', 'fmwave-core' ),
			),	
				array(
					'type'    => Controls_Manager::TEXTAREA,
					'id'      => 'title',
					'label'   => esc_html__( 'Title', 'fmwave-core' ),
					'default' => 'Company And Music Concert',
				),
					array(
					'type'    => Controls_Manager::TEXTAREA,
					'id'      => 'subtitle',
					'label'   => esc_html__( 'Sub Title', 'fmwave-core' ),
					'default' => 'Have a Question About',
				),	
			
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button',
				'label'   => esc_html__( 'Button', 'fmwave-core' ),
                 'condition' => array( 'layout' => array( 'layout1', 'layout2', 'layout3' ) ),         
			),
				array(
					'type'    => Controls_Manager::TEXT,
					'id'      => 'buttontext',
					'label'   => esc_html__( 'Button Text', 'fmwave-core' ),
					'default' => 'GET A QUOTE',
				),
				array(
					'type'    => Controls_Manager::URL,
					'id'      => 'buttonurl',
					'label'   => esc_html__( 'Button URL', 'fmwave-core' ),
					'placeholder' => 'https://your-link.com',
				),
			array(
				'mode' => 'section_end',
			),		

         // Title style
        array(
            'mode'    => 'section_start',
            'id'      => 'sec_title_style',
            'label'   => esc_html__( 'Title', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
        ),
        array(
            'type'    => Controls_Manager::COLOR,
            'id'      => 'title_color',
            'label'   => esc_html__( 'Color', 'fmwave-core' ),
            'default' => '#111111',                       
            'selectors' => array(
                '{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
            ),
        ),  
        array( 
            'mode'      => 'group',
            'type'      => Group_Control_Typography::get_type(),
            'name'      => 'title_font_size',                
            'label'     => esc_html__( 'Icon Typography', 'fmwave-core' ),
            'selector'  => '{{WRAPPER}} .item-title',
        ),
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'mode'          => 'responsive',
            'id'      => 'title_padding',
            'label'   => esc_html__( 'Padding', 'fmwave-core' ),
            'selectors' => array(
                '{{WRAPPER}} .item-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
            ),
            'separator' => 'before',
        ),  
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'mode'          => 'responsive',
            'id'      => 'title_margin',
            'label'   => esc_html__( 'Margin', 'fmwave-core' ),                 
            'selectors' => array(
                '{{WRAPPER}} .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
            ),
            'separator' => 'before',
        ),

      array(
          'mode' => 'section_end',
      ),  

       // Title style
        array(
            'mode'    => 'section_start',
            'id'      => 'sec_sub_title_style',
            'label'   => esc_html__( 'Sub Title', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
        ),
       

        array(
            'type'    => Controls_Manager::COLOR,
            'id'      => 'sub_title_color',
            'label'   => esc_html__( 'Color', 'fmwave-core' ),
            'default' => '#111111',                       
            'selectors' => array(
                    '{{WRAPPER}} .item-subtitle' => 'color: {{VALUE}}',
                ),
        ),  
        array( 
            'mode'      => 'group',
            'type'      => Group_Control_Typography::get_type(),
            'name'      => 'sub_title_font_size',                
            'label'     => esc_html__( 'Icon Typography', 'fmwave-core' ),
            'selector'  => '{{WRAPPER}} .item-subtitle',
        ),
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'mode'          => 'responsive',
            'id'      => 'sub_title_padding',
            'label'   => esc_html__( 'Padding', 'fmwave-core' ),
            'selectors' => array(
                '{{WRAPPER}} .item-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ),
            'separator' => 'before',
        ),  
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'mode'          => 'responsive',
            'id'      => 'sub_title_margin',
            'label'   => esc_html__( 'Margin', 'fmwave-core' ),                 
            'selectors' => array(
                '{{WRAPPER}} .item-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ),
            'separator' => 'before',
        ),  

      array(
          'mode' => 'section_end',
      ),  

      
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$template = 'cta';
		return $this->rt_template( $template, $data );
	}
}