<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
if ( ! defined( 'ABSPATH' ) ) exit;

class Counter extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Counter', 'fmwave-core' );
		$this->rt_base = 'rt-counter';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_script( 'waypoints' );
		wp_enqueue_script( 'jquery-counterup' );
	}
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'fmwave-core' ),
					'layout2' => esc_html__( 'Layout 2', 'fmwave-core' ),					
					'layout3' => esc_html__( 'Layout 3', 'fmwave-core' ),					
				),
				'default' => 'layout1',
			),
			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'icontype',
				'label'   => esc_html__( 'Icon Type', 'fmwave-core' ),
				'options' => array(
					'icon'  => esc_html__( 'Icon', 'fmwave-core' ),
					'image' => esc_html__( 'Custom Image', 'fmwave-core' ),
				),
				'default' => 'icon',	
				'condition'   =>  array( 'layout' => array( 'layout3' )),
			),
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'icon',
				'label'   => esc_html__( 'Icon', 'fmwave-core' ),
				'default' => [
			      'value' => 'fas fa-smile-wink',
			      'library' => 'fa-solid',
			  ],	
			  'condition'   => array( 'icontype' => array( 'icon' ), 'layout' => array( 'layout3' )),
			),	

			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'image',
				'label'   => esc_html__( 'Image', 'fmwave-core' ),
				'condition'   => array( 'icontype' => array( 'image' ) ),
				'description' => esc_html__( 'Recommended image Background', 'fmwave-core' ),
				
				'condition'   => array( 'icontype' => array( 'image' ), 'layout' => array( 'layout3' )),
			),

			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Counter Number', 'fmwave-core' ),
				'default' => 5000,
			),

			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'suffix',
				'label'   => esc_html__( 'Counter Suffix', 'fmwave-core' ),
				'description' => esc_html__( 'Put any text or symbol after Counter Number eg. +', 'fmwave-core' ),
			),

			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'default' => esc_html__( 'Residential Projects', 'fmwave-core' ),
			),

			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'speed',
				'label'   => esc_html__( 'Animation Speed', 'fmwave-core' ),
				'default' => 5000,
				'description' => esc_html__( 'The total duration of the count animation in milisecond eg. 5000', 'fmwave-core' ),
			),

			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'steps',
				'label'   => esc_html__( 'Animation Steps', 'fmwave-core' ),
				'default' => 10,
				'description' => esc_html__( 'Counter steps eg. 10', 'fmwave-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Title style
			array(
			    'mode'    => 'section_start',
			    'id'      => 'counter_style',
			    'label'   => esc_html__( 'Icon Style', 'fmwave-core' ),
			    'tab'     => Controls_Manager::TAB_STYLE,
			    'condition'   =>  array( 'layout' => array( 'layout3' )),
			),      			
			array(
				'type'    	=> Controls_Manager::COLOR,
				'id'      	=> 'counter_icon_color',
				'label'   	=> __( 'Icon Color', 'fmwave-core' ),
				'default' 	=> '',                       
				'selectors' => array(
					'{{WRAPPER}} .progress-box-style .item-icon i' => 'color: {{VALUE}}',      
					),
			),  	
			
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'id'      => 'counter_icon_padding',
				'label'   => __( 'Padding', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .progress-box-style .item-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
									   
				),
				'separator' => 'before',
			),  
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'id'      => 'counter_icon_margin',
				'label'   => __( 'Margin', 'fmwave-core' ),                 
				'selectors' => array(
					'{{WRAPPER}} .progress-box-style .item-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
				),
				'separator' => 'before',
			),  
				
			array(
			'mode' => 'section_end',
			),
		// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'counter_number_style',
				'label'   => esc_html__( 'Counter Number  Style', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),      
			array(
			    'type'    	=> Controls_Manager::COLOR,
			    'id'      	=> 'count_number_color',
			    'label'   	=> __( 'Color', 'fmwave-core' ),
			    'default' 	=> '',                       
			    'selectors' => array(
			        '{{WRAPPER}} .progress-box-style .rt-el-counter' => 'color: {{VALUE}}',      
			        '{{WRAPPER}} .progress-box-layout1-new .count-number' => 'color: {{VALUE}}',      
			        ),
			),  
			array( 
			    'mode'      => 'group',
			    'type'      => Group_Control_Typography::get_type(),
			    'name'      => 'counter_number_font_size',                
			    'label'     => esc_html__( 'Typography', 'fmwave-core' ),
			    'selector'  =>'{{WRAPPER}} .progress-box-style .rt-el-counter,{{WRAPPER}} .progress-box-layout1-new .count-number',		    
			),
			array(
			    'type'    => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'id'      => 'counter_number_padding',
			    'label'   => __( 'Padding', 'fmwave-core' ),
			    'selectors' => array(
			        '{{WRAPPER}} .progress-box-style .rt-el-counter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
			        '{{WRAPPER}} .progress-box-layout1-new .count-number' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
			                           
			    ),
			    'separator' => 'before',
			),  
			array(
			    'type'    => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'id'      => 'counter_number_margin',
			    'label'   => __( 'Margin', 'fmwave-core' ),                 
			    'selectors' => array(
			        '{{WRAPPER}} .progress-box-style .rt-el-counter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
			        '{{WRAPPER}} .progress-box-layout1-new .count-number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
			    ),
			    'separator' => 'before',
			),  
			array(
				'mode' => 'section_end',
			),
			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'counter_title_style',
				'label'   => esc_html__( 'Counter Title  Style', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),      
			array(
			    'type'    	=> Controls_Manager::COLOR,
			    'id'      	=> 'count_title_color',
			    'label'   	=> __( 'Color', 'fmwave-core' ),
			    'default' 	=> '',                       
			    'selectors' => array(
			        '{{WRAPPER}} .progress-box-style .count-title' => 'color: {{VALUE}}',      
			        '{{WRAPPER}} .progress-box-layout1-new .item-title' => 'color: {{VALUE}}',      
			        ),
			),  
			array( 
			    'mode'      => 'group',
			    'type'      => Group_Control_Typography::get_type(),
			    'name'      => 'counter_title_font_size',                
			    'label'     => esc_html__( 'Typography', 'fmwave-core' ),
			    'selector'  =>'{{WRAPPER}} .progress-box-style .count-title, {{WRAPPER}} .progress-box-layout1-new .item-title',
			    'selector'  =>'{{WRAPPER}} .progress-box-layout1-new .item-title',
			),
			array(
			    'type'    => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'id'      => 'counter_title_padding',
			    'label'   => __( 'Padding', 'fmwave-core' ),
			    'selectors' => array(
			        '{{WRAPPER}} .progress-box-style .count-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
			        '{{WRAPPER}} .progress-box-layout1-new .item-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
			                           
			    ),
			    'separator' => 'before',
			),  
			array(
			    'type'    => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'id'      => 'counter_title_margin',
			    'label'   => __( 'Margin', 'fmwave-core' ),                 
			    'selectors' => array(
			        '{{WRAPPER}} .progress-box-style .count-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
			        '{{WRAPPER}} .progress-box-layout1-new .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
			    ),
			    'separator' => 'before',
			),  
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		switch ( $data['layout'] ) {
			case 'layout2':
				$template = 'counter-2';
			break;	
			case 'layout3':
				$template = 'counter-3';
			break;		
			default:
				$template = 'counter-1';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}