<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use Elementor\Controls_Manager;
use radiustheme\Fmwave\Helper;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Chart extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Music Chart', 'fmwave-core' );
		$this->rt_base = 'rt-chart';
		$this->rt_translate = array(
			'cols'  => array(
				'12' =>esc_html__( '1 Col', 'fmwave-core' ),
				'6'  =>esc_html__( '2 Col', 'fmwave-core' ),
				'4'  =>esc_html__( '3 Col', 'fmwave-core' ),
				'3'  =>esc_html__( '4 Col', 'fmwave-core' ),
				'2'  =>esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_script( 'wp-mediaelement' );
	}
	public function rt_fields(){

		$prefix = FMWAVE_CORE_CPT;
		$terms = get_terms( array( 'taxonomy' => "{$prefix}_music_category" ) );
		$category_dropdown = array( '0' => esc_html__( 'All Categories', 'fmwave-core' ) );
		foreach ( $terms as $category ) {
			$category_dropdown[$category->term_id] = $category->name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'fmwave-core' ),
					'layout2' => esc_html__( 'Layout 2', 'fmwave-core' ),
					'layout3' => esc_html__( 'Layout 3', 'fmwave-core' ),
					'layout4' => esc_html__( 'Layout 4', 'fmwave-core' ),
					'layout5' => esc_html__( 'Layout 5', 'fmwave-core' ),
				),
				'default' => 'layout1',
			),
			array(
				'type'    			=> Controls_Manager::SELECT2,
				'id'      			=> 'orderby',
				'label'   			=> esc_html__( 'Order By', 'fmwave-core' ),
				'options' 			=> array(
					'date'        => esc_html__( 'Date (Recents comes first)', 'fmwave-core' ),
					'title'       => esc_html__( 'Title', 'fmwave-core' ),
					'menu_order'  => esc_html__( 'Custom Order', 'fmwave-core' ),
				),
				'default' 			=> 'date',
			),
			array(
				'type'    	=> Controls_Manager::MEDIA,
				'id'    	=> 'chart_top_image',
				'default' 	=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
				'label'   => esc_html__( 'Chart Heading Image', 'fmwave-core' ),
				'description' => esc_html__( 'Upload the chart heading Image', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout1' )),
			),			
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'fmwave-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',
				'condition'   => array( 'layout' => array( 'layout1' )),
			),	
			
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'time_text',
				'label'   => esc_html__( 'Name of the Duration Heading', 'fmwave-core' ),
				'description' => esc_html__( 'Like: Weekly, Monthly, Daily', 'fmwave-core' ),
				'default' => esc_html__( 'Monthly', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout1' )),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'chart_name',
				'label'   => esc_html__( 'Name of the Chart', 'fmwave-core' ),
				'description' => esc_html__( 'Like: Top chart, Best Chart, favorite Chart', 'fmwave-core' ),
				'default' => esc_html__( 'Top Chart', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout1' )),
			),
			array(
				'id'    => 'category',
				'label' => __( 'Category', 'fmwave-core' ),
				'type'  =>  Controls_Manager::SELECT,
				'options'   => $category_dropdown,
				'default'   => '0',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_per_page',
				'label'   => esc_html__( 'How many Music you want to show?', 'fmwave-core' ),
				'default' => '10',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'fm_track_ids',
				'label'   => esc_html__( 'Post IDs to show post.', 'fmwave-core' ),
				'default' => '',
				'description' => esc_html__( 'Comma Separated Value, Like: 258,369,147,741,852,963', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_count',
				'label'       =>esc_html__( 'Show View Count', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' =>esc_html__( 'Show or Hide View Style. Default: On', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout2' )),
			),
			array(
				'mode' => 'section_end',
			),

			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array( 
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'title_typo',                
				'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .chart-box-content .chart-list > ol > li .item-song, 
								{{WRAPPER}} .chart-box-content .chart-list > ol > li .hover-content .media .media-body .item-title,
								{{WRAPPER}} .popular-chart-box .single-music .music-name .item-title, 
								{{WRAPPER}} .track-list-3 ol li .song-name,
								{{WRAPPER}} .track-list-4 ol li .song-name,
								{{WRAPPER}} .track-list-5 ol li .song-name',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .single-music .music-name .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-music .media .media-body .item-heading .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-music .media .media-body .item-heading .item-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .chart-box-content .chart-list > ol > li .item-song' => 'color: {{VALUE}}',
					'{{WRAPPER}} .track-list-3 ol li .song-name' => 'color: {{VALUE}}',
					'{{WRAPPER}} .track-list-4 ol li .song-name' => 'color: {{VALUE}}',
					'{{WRAPPER}} .track-list-5 ol li .song-name' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_link_color',
				'label'   => __( 'Title Link Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .track-list-3 ol li .song-name a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .track-list-4 ol li .song-name a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .track-list-5 ol li .song-name a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .chart-box-content .chart-list > ol > li .hover-content .media .media-body .item-title a:hover' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array( 'layout1', 'layout3', 'layout4', 'layout5' )),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_link_hovcolor',
				'label'   => __( 'Title Link Hover Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .track-list-3 ol li .song-name a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .track-list-4 ol li .song-name a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .track-list-5 ol li .song-name a:hover' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array( 'layout3', 'layout4', 'layout5' )),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_no',
				'label'   => __( 'Number Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .chart-box-content .chart-list > ol > li:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .track-list-3 ol li:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .track-list-4 ol li:before' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array( 'layout1', 'layout3', 'layout4' )),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_style_color',
				'label'   => __( 'Meta Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .single-music .music-name .item-subtitle' => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-music .media .media-body .music-meta li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-music .media .media-body .music-meta li i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-music .music-duration' => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-music .music-play a' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .popular-chart-box .single-music .music-play a' =>  'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array( 'layout2' )),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'top_title_color',
				'label'   => __( 'Top Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .chart-box-content > .item-img .item-content .item-subtitle' => 'color: {{VALUE}}',
					'{{WRAPPER}} .chart-box-content > .item-img .item-content .item-title' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array( 'layout1' )),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'top_bg_color',
				'label'   => esc_html__( 'Top Background Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .chart-box-content > .item-img' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array( 'layout1' )),
			),
			array(
				'mode' => 'section_end',
			),

			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'music_list_style',
				'label'   => esc_html__( 'Music List', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'layout' => array( 'layout1','layout3','layout5' )),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'list_bg_color',
				'label'   => esc_html__( 'List Background Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .chart-box-content .chart-list > ol > li:nth-child(even)' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .track-list-3 ol li' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .track-list-5 ol li' => 'background-color: {{VALUE}}',
				),				
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'list_border_color',
				'label'   => esc_html__( 'Box Border Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .chart-box-content' => 'border-color: {{VALUE}}',
				),
			),
			array(
            'type'    => Controls_Manager::DIMENSIONS,
            'mode'          => 'responsive',
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'list_padding',
            'label'   => __( 'Padding', 'fmwave-core' ),
            'selectors' => array(
                '{{WRAPPER}} .chart-box-content .chart-list > ol > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
                '{{WRAPPER}} .track-list-3 ol li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
                '{{WRAPPER}} .track-list-5 ol li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
            ),
            'separator' => 'before',
        ),
			array(
				'mode' => 'section_end',
			),
		
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		switch ( $data['layout'] ) {
			case 'layout5':
				$template = 'chart-5';
			break;
			case 'layout4':
				$template = 'chart-4';
			break;
			case 'layout3':
				$template = 'chart-3';
			break;
			case 'layout2':
				$template = 'chart-2';
			break;
			default:
				$template = 'chart-1';
			break;
			}
		return $this->rt_template( $template, $data );
	}
}