<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Button extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Fmwave Button', 'fmwave-core' );
		$this->rt_base = 'rt-button';	
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'fmwave-core' ),
				'options' => array(
					'1' => esc_html__( 'Style 1', 'fmwave-core' ),
				),
				'default' => '1',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'btntext',
				'label'   => esc_html__( 'Button Text', 'fmwave-core' ),
				'default' => 'Lorem Ipsum',
			),
			array(
				'type'  => Controls_Manager::URL,
				'id'    => 'url',
				'label' => esc_html__( 'Button Link', 'fmwave-core' ),
				'placeholder' => 'https://your-link.com',
			),
			array (
				'type'    => Controls_Manager::CHOOSE,
				'mode'    => 'responsive',
				'id'      => 'align',
				'label'   => esc_html__( 'Alignment', 'fmwave-core' ),
					'options' => array(
					'left'    => array(
						'title' => esc_html__( 'Left', 'fmwave-core' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'fmwave-core' ),
						'icon' => 'eicon-text-align-center',
					),
					'right' => array(
						'title' => esc_html__( 'Right', 'fmwave-core' ),
						'icon' => 'eicon-text-align-right',
					),

				),
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'prefix_class' => 'content-align-%s',
				'default' => 'left',
				'selectors' => array(
					'{{WRAPPER}} .rt-item-btn' => 'text-align: {{VALUE}};',
				),
			),
			array (
				'mode' => 'section_end',
			),
			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button_style',
				'label'   => esc_html__( 'Button', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),			
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'button_typo',
				'label'   => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector' => '{{WRAPPER}} .rt-item-btn a',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_color',
				'label'   => __( 'Color', 'fmwave-core' ),
				'default' => '',                       
				'selectors' => array(
					'{{WRAPPER}} .rt-item-btn a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_hover_color',
				'label'   => __( 'Hover Color', 'fmwave-core' ),
				'default' => '',                       
				'selectors' => array(
					'{{WRAPPER}} .rt-item-btn a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_bg_color',
				'label'   => __( 'Background Color', 'fmwave-core' ),
				'default' => '',                       
				'selectors' => array(
					'{{WRAPPER}} .rt-item-btn a' => 'background-color: {{VALUE}}',
				),
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_bg_hover_color',
				'label'   => __( 'Background Hover Color', 'fmwave-core' ),
				'default' => '',                       
				'selectors' => array(
					'{{WRAPPER}} .rt-item-btn a:after' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'mode'          => 'responsive',
				'id'      => 'button_radius',
				'label'   => __( 'Border Radius', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .rt-item-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					'{{WRAPPER}} .rt-item-btn a:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				 'mode'          => 'responsive',
				'id'      => 'button_padding',
				'label'   => __( 'Padding', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .rt-item-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
				'separator' => 'before',
			),  
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'mode'          => 'responsive',
				'id'      => 'button_margin',
				'label'   => __( 'Margin', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .rt-item-btn a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
				'separator' => 'before',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}
	protected function render() {
		$data 		= $this->get_settings();	
		$template 	= 'button';
		return $this->rt_template( $template, $data );		
	}
}