<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;
class Blog_Post extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name =esc_html__( 'Blog Posts', 'fmwave-core' );
		$this->rt_base = 'rt-blog-post';
		$this->rt_translate = array(
			'cols'  => array(
				'12' =>esc_html__( '1 Col', 'fmwave-core' ),
				'6'  =>esc_html__( '2 Col', 'fmwave-core' ),
				'4'  =>esc_html__( '3 Col', 'fmwave-core' ),
				'3'  =>esc_html__( '4 Col', 'fmwave-core' ),
				'2'  =>esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	private function rt_cat_dropdown() {  
		$terms = get_terms( [
			'taxonomy' => "category",
			'hide_empty' => true,
		]);

		$category_dropdown = [];
		foreach ( $terms as $category ) {
			$category_dropdown[$category->slug] = $category->name;
		}
		return $category_dropdown;
	}

	public function rt_fields(){
		$categories = get_categories();
		foreach ( $categories as $category ) {
			$category_dropdown[$category->slug] = $category->name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_Layout',
				'label'   =>esc_html__( 'Layout', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   =>esc_html__( 'Layout', 'fmwave-core' ),
				'options' => array(
					'style1' =>esc_html__( 'Style 1', 'fmwave-core' ),
					'style2' =>esc_html__( 'Style 2', 'fmwave-core' ),
					'style3' =>esc_html__( 'Style 3', 'fmwave-core' ),
					'style4' =>esc_html__( 'Style 4', 'fmwave-core' ),
				),
				'default' => 'style1',
			),
		array(
				'mode' => 'section_end',
			),		

		array(
			'mode'    => 'section_start',
			'id'      => 'sec_qurey',
			'label'   =>esc_html__( 'Qurey', 'fmwave-core' ),
		),
		array(
			'type'    => Controls_Manager::SELECT2,
			'id'      => 'cat',
			'label'   => esc_html__( 'Categories', 'fmwave-core' ),
			'options' => $category_dropdown,
			'default' => '0',			
			'multiple' => true,
		),
		array(
			'type'    			=> Controls_Manager::SELECT2,
			'id'      			=> 'orderby',
			'label'   			=> esc_html__( 'Order By', 'fmwave-core' ),
			'options' 			=> array(
				'date'        => esc_html__( 'Date (Recents comes first)', 'fmwave-core' ),
				'title'       => esc_html__( 'Title', 'fmwave-core' ),
				'menu_order'  => esc_html__( 'Custom Order (Available via Order field inside Page Attributes box)', 'fmwave-core' ),
			),
			'default' 			=> 'date',
		),
		array(
			'type'    		=> Controls_Manager::NUMBER,
			'id'      		=> 'number',
			'label'   		=> esc_html__( 'Total number of posts', 'fmwave-core' ),
			'default' 		=> 5,
			'description' => esc_html__( 'Write -1 to show all', 'fmwave-core' ),
		),
		array(
			'type'        => Controls_Manager::SWITCHER,
			'id'          => 'content_display',
			'label'       =>esc_html__( 'Post short Content ', 'fmwave-core' ),
			'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
			'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
			'default'     => 'no',
			'description' =>esc_html__( 'Show or Hide short Content. Default: On', 'fmwave-core' ),
		),
		array(
			'type'    => Controls_Manager::NUMBER,
			'id'      => 'word_count',
			'label'   =>esc_html__( 'Word count', 'fmwave-core' ),
			'default' => 18,
			'description' =>esc_html__( 'Maximum number of words', 'fmwave-core' ),
			'condition'   => array( 'content_display' => array( 'yes')),
		),
		array(
			'type'        => Controls_Manager::SWITCHER,
			'id'          => 'show_date',
			'label'       =>esc_html__( 'Post Date ', 'fmwave-core' ),
			'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
			'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
			'default'     => 'yes',
			'description' =>esc_html__( 'Show or Hide short Date. Default: On', 'fmwave-core' ),
		),
		array(
			'type'        => Controls_Manager::SWITCHER,
			'id'          => 'show_author',
			'label'       =>esc_html__( 'Post Author ', 'fmwave-core' ),
			'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
			'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
			'default'     => 'yes',
			'description' =>esc_html__( 'Show or Hide short Author. Default: On', 'fmwave-core' ),
		),
		array(
			'type'        => Controls_Manager::SWITCHER,
			'id'          => 'show_category',
			'label'       =>esc_html__( 'Post Category ', 'fmwave-core' ),
			'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
			'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
			'default'     => 'no',
			'description' =>esc_html__( 'Show or Hide short Category. Default: Off', 'fmwave-core' ),
		),
		array(
			'type'    => Controls_Manager::NUMBER,
			'id'      => 'title_count',
			'label'   =>esc_html__( 'Title Word count', 'fmwave-core' ),
			'default' => 18,
			'description' =>esc_html__( 'Maximum number of words', 'fmwave-core' ),
		),	
		array(
			'mode' => 'section_end',
		),				
		
		// Responsive Columns
		array(
			'mode'    => 'section_start',
			'id'      => 'sec_responsive',
			'label'   =>esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
		),
		array(
			'type'    => Controls_Manager::SELECT2,
			'id'      => 'col_lg',
			'label'   =>esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
			'options' => $this->rt_translate['cols'],
			'default' => '4',
		),
		array(
			'type'    => Controls_Manager::SELECT2,
			'id'      => 'col_md',
			'label'   =>esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
			'options' => $this->rt_translate['cols'],
			'default' => '4',
		),
		array(
			'type'    => Controls_Manager::SELECT2,
			'id'      => 'col_sm',
			'label'   =>esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
			'options' => $this->rt_translate['cols'],
			'default' => '6',
		),
		array(
			'type'    => Controls_Manager::SELECT2,
			'id'      => 'col_xs',
			'label'   =>esc_html__( 'Phones: < 768px', 'fmwave-core' ),
			'options' => $this->rt_translate['cols'],
			'default' => '12',
		),
		array(
			'type'    => Controls_Manager::SELECT2,
			'id'      => 'col_mobile',
			'label'   =>esc_html__( 'Small Phones: < 480px', 'fmwave-core' ),
			'options' => $this->rt_translate['cols'],
			'default' => '12',
		),
		array(
			'mode' => 'section_end',
		),

		// Title style
		array(
		    'mode'    => 'section_start',
		    'id'      => 'blog_post_title_style',
		    'label'   => esc_html__( 'Title Style', 'fmwave-core' ),
		    'tab'     => Controls_Manager::TAB_STYLE,
		),
		array( 
			'mode'      => 'group',
			'type'      => Group_Control_Typography::get_type(),
			'name'      => 'title_font_size',                
			'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
			'selector'  =>'{{WRAPPER}} .blog-default .blog-box .item-content .item-title',
		),
		array(
			'type'    => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em' ],
			'id'      => 'title_margin',
			'label'   => esc_html__( 'Margin', 'fmwave-core' ),                 
			'selectors' => array(
				'{{WRAPPER}} .blog-default .blog-box .item-content .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
			),
			'separator' => 'before',
		),  
			
			
		array(

		'mode' => 'section_end',
		),

		// Content style
		array(
			'mode'    => 'section_start',
			'id'      => 'blog_post_content_style',
			'label'   => esc_html__( 'Content Style', 'fmwave-core' ),
			'tab'     => Controls_Manager::TAB_STYLE,
		),
		array( 
			'mode'      => 'group',
			'type'      => Group_Control_Typography::get_type(),
			'name'      => 'content_font_size',                
			'label'     => esc_html__( 'Content Typography', 'fmwave-core' ),
			'selector'  =>'{{WRAPPER}} .blog-default .blog-box .item-content .blog-text p',
		), 
		array(
			'type'    => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em' ],
			'id'      => 'content_margin',
			'label'   => esc_html__( 'Margin', 'fmwave-core' ),                 
			'selectors' => array(
				'{{WRAPPER}} .blog-default .blog-box .item-content .blog-text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
			),
			'separator' => 'before',
		), 	
		array(

		'mode' => 'section_end',
		),
		
		);
		return $fields;
	}
	protected function render() {	
	$data = $this->get_settings();	
		switch ( $data['style'] ) {
			case 'style4':
				$template = 'blog-post-4';			
			break;			
			case 'style3':
				$template = 'blog-post-3';			
			break;			
			case 'style2':
				$template = 'blog-post-2';			
			break;			
			default:
				$template = 'blog-post-1';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}