<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;
class Services_Tab extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Services Banner Tab', 'fmwave-core' );
		$this->rt_base = 'rt-services-tab';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => esc_html__( '1 Col', 'fmwave-core' ),
				'6'  => esc_html__( '2 Col', 'fmwave-core' ),
				'4'  => esc_html__( '3 Col', 'fmwave-core' ),
				'3'  => esc_html__( '4 Col', 'fmwave-core' ),
				'2'  => esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_style(  'fmwave-fmwave-slick' );
		wp_enqueue_style(  'fmwave-slick-theme' );
		wp_enqueue_script( 'fmwave-slick' );
	}

	public function rt_fields(){
		$cpt = FMWAVE_CORE_CPT;
		$terms  = get_terms( array( 'taxonomy' => "{$cpt}_services_category", 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => esc_html__( 'All Categories', 'fmwave-core' ) );
		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Total number of items', 'fmwave-core' ),
				'default' => 12,
				'description' => esc_html__( 'Write -1 to show all', 'fmwave-core' ),
			),				
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat',
				'label'   => esc_html__( 'Categories', 'fmwave-core' ),
				'options' => $category_dropdown,
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Order By', 'fmwave-core' ),
				'options' => array(
					'date'        => esc_html__( 'Date (Recents comes first)', 'fmwave-core' ),
					'title'       => esc_html__( 'Title', 'fmwave-core' ),
					'menu_order'  => esc_html__( 'Custom Order (Available via Order field inside Page Attributes box)', 'fmwave-core' ),
				),
				'default' => 'date',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'count',
				'label'   => esc_html__( 'Word count', 'fmwave-core' ),
				'default' => 15,
				'description' => esc_html__( 'Maximum number of words', 'fmwave-core' ),
			),
			
			array(
				'mode' => 'section_end',
			),			
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		$template = 'services-tab-1';			
		return $this->rt_template( $template, $data );
	}
}