<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
 
namespace radiustheme\fmwave;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;
use radiustheme\fmwave\WC_Functions;
use \WP_Query;


$thumb_size = 'fmwave-v3-b';
 
if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];
$excerpt_count = $data['excerpt_count'];	
$cat_single_box = $data['cat_single_box'];
 
$args = array(
	'post_type' => 'product',
	'post_status' => 'publish',
	'orderby' => $post_sorting,
	'order' => $post_ordering,
	'posts_per_page' => $number_of_post,
	'paged'          => $paged,	
);
 
if ( $cat_single_box != 0 ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'product_cat',
			'field'    => 'term_id',
			'terms'    => $cat_single_box,
		),
	);
}
$query = new WP_Query( $args );
$temp = Helper::wp_set_temp_query( $query );
 
$col_class = "row-cols-xl-{$data['col_xl']} row-cols-lg-{$data['col_lg']} row-cols-md-{$data['col_md']}  row-cols-sm-{$data['col_sm']} row-cols-{$data['col']}";

?>
<div class="default-layout shop-layout-<?php echo esc_attr( $data['style'] );?>">
	<div class="row <?php echo esc_attr( $col_class ); ?>">
		<?php if ( $query->have_posts() ) { ?>
			<?php while ( $query->have_posts() ) {
				$query->the_post();
				global $product;
				$product_id  = $product->get_id();
                $excerpt = wp_trim_words(get_the_excerpt(), $excerpt_count, '');
                $product_title = wp_trim_words(get_the_title(), $title_count, '');
			?>
			<div class="col">
				<div class="item-box">
					<div class="item-img">
						<a href="<?php the_permalink(); ?>">
							<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size , ['class' => 'img-fluid mb-10 width-100'] );
								} else {
									if ( !empty( PanpieTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( PanpieTheme::$options['no_preview_image']['id'], $thumb_size );
									} else {
										echo '<img class="wp-post-image" src="' . Helper::get_img( 'noimage_400X400.jpg' ) . '" alt="'.get_the_title().'">';
									}
								}
							?>
						</a>
						<div class="btn-icons">
							<?php
								if ( RDTheme::$options['wc_shop_wishlist_icon'] ) WC_Functions::print_add_to_wishlist_icon();
								if ( RDTheme::$options['wc_shop_quickview_icon'] ) WC_Functions::print_quickview_icon();
								if ( RDTheme::$options['wc_shop_compare_icon'] ) WC_Functions::print_compare_icon();
							?>
						</div>
					</div>
					<div class="item-content">
						<?php if ( $data['cat_showhide'] == 'yes' ) { ?>									
						<?php 
						$terms = get_the_terms( get_the_ID(), 'product_cat' );
						foreach ($terms as $term) {
							if( $term->term_id ) {
								$link= get_term_link( $term->term_id);
			    				echo '<a class="cat" href="'.$link.'">'.$term->name.'</a>'; 
		    				}
	    				} ?>
	    				<?php } ?>
	    				
						<?php if ( $data['title_showhide'] == 'yes' ) { ?>
						<h3 class="rtin-title"><a href="<?php the_permalink(); ?>">
						<?php echo wp_kses( $product_title, 'alltext_allow' ); ?></a></h3>
						<?php } ?>
						
						<?php if ( $data['rating_showhide'] == 'yes' ) { ?>
						<div class="rating-custom">
							<?php wc_get_template( 'rating.php' ); ?>
						</div>
						<?php } ?>
						
						<?php if ( $data['price_showhide'] == 'yes' ) { ?>
						<?php if ( $price_html = $product->get_price_html() ) : ?>
							<div class="rtin-price"><?php echo wp_kses_post( $price_html ); ?></div>
						<?php endif; ?>
						<?php } ?>

						<?php if ( $data['excerpt_display'] == 'yes' ) { ?>
						<p><?php echo wp_kses_post( $excerpt );?></p>
						<?php } ?>
						
						<div class="btn-addto-cart">
							<a href="<?php the_permalink(); ?>"><?php echo esc_html__('Add to cart', 'fmwave-core') ?></a>
						</div>
					</div>
				</div>
			</div>
 
			<?php } ?>
		<?php } ?>
		<?php Helper::wp_reset_temp_query( $temp ); ?><?php wp_reset_postdata(); ?>
	</div>
</div>