<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use \WP_Query;

$thumb_size1 = 'fmwave-v4-b';
$thumb_size2 = 'fmwave-show-isotope';
$prefix = FMWAVE_CORE_CPT;
$args = array(
	'post_type'  => "{$prefix}_video",
	'posts_per_page' => $data['number'],
	'order' 			=> $data['post_ordering'],
	'orderby' 			=> $data['post_orderby'],
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => "{$prefix}_video_category",
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

if ( !empty( $data['fm_post_ids'] ) ) {
	$args['post__in'] = array( $data['fm_post_ids'] );
}

$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query );
?>

<div class="video-tab-3" id="video">
	<div class="tab-content">
		<?php
		$i = 1;
		if ($query->have_posts()) {
			while ( $query->have_posts() ) { $query->the_post();
				$get_view = get_post_meta( get_the_ID(), 'video_view' , true );
				$get_length = get_post_meta( get_the_ID(), "{$prefix}_video_length" , true );
				$get_video_link = get_post_meta( get_the_ID(), "{$prefix}_video_link" , true );
		?>
		<div class="tab-pane fade <?php if ( $i == 1 ) { ?>active show<?php } ?>" id="tab<?php echo esc_attr( $i ); ?>">
			<div class="item-img">
				<?php if ( has_post_thumbnail() ){ ?>
					<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( $thumb_size1 );?></a>
				<?php }	?>
			</div>
			<div class="item-content">
				<div class="video-icon">
					<a class="play-btn popup-youtube" href="<?php echo esc_url( $get_video_link); ?>">
						<i class="fas fa-play"></i>
					</a>
				</div>
				<?php if ( 'yes' == $data['title_style'] ) { ?>
				<h2 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
				<?php } ?>
				<ul class="entry-meta">
					<?php if ( ( 'yes' == $data['show_length'] ) && ( !empty( $get_length ) ) ) { ?>
						<li><i class="far fa-clock"></i><?php echo esc_html( $get_length ); ?></li>
						
					<?php } if ( 'yes' == $data['show_count'] && function_exists( 'fmwave_views' ) ) { ?>
						<li><i class="far fa-eye"></i><?php echo fmwave_views(); ?></li>
					<?php } ?>
				</ul>
			</div>
		</div>
		<?php $i++; } ?>
		<?php } else { ?>
			<div class="text-center"><?php esc_attr_e('No Video Found' , 'fmwave-core'); ?></div>
		<?php } ?>
		<?php Helper::wp_reset_temp_query( $temp );?>
	</div>

	<ul class="nav nav-tabs" role="tablist">
		<?php
		$i = 1;
		if ($query->have_posts()) {
			while ( $query->have_posts() ) { $query->the_post();
			$small_title = wp_trim_words( get_the_title(), $data['title_small_count'], '' );
			
			if( $i == 1){
				$act = 'active';
				$ari = 'true';
			}else{
				$act = '';
				$ari = 'false';
			}
		?>
		<li class="nav-item">
			<a class="nav-link <?php echo esc_attr($act); ?>" data-toggle="tab" href="#tab<?php echo esc_attr( $i ); ?>" role="tab" aria-selected="<?php echo esc_attr($ari); ?>">
				<div class="item-img">
					<?php if ( has_post_thumbnail() ){ ?>
						<?php the_post_thumbnail( $thumb_size2 );?>
					<?php }	?>
					<div class="video-icon">
						<span class="play-btn">
							<i class="fas fa-play"></i>
						</span>
					</div>
				</div>
				<div class="item-content">					
					<?php if ( 'yes' == $data['title_style'] ) { ?>
					<h3 class="item-title"><?php echo esc_html( $small_title );?></h3>
					<?php } ?>
					<ul class="entry-meta">
						<?php if ( ( 'yes' == $data['show_length'] ) && ( !empty( $get_length ) ) ) { ?>
							<li><i class="far fa-clock"></i><?php echo esc_html( $get_length ); ?></li>
							
						<?php } if ( 'yes' == $data['show_count'] && function_exists( 'fmwave_views' ) ) { ?>
							<li><i class="far fa-eye"></i><?php echo fmwave_views(); ?></li>
						<?php } ?>
					</ul>
				</div>
			</a>
		</li>
		<?php $i++; } ?>
		<?php } else { ?>
			<div class="text-center"><?php esc_attr_e('No Video Found' , 'fmwave-core'); ?></div>
		<?php } ?>
		<?php Helper::wp_reset_temp_query( $temp );?>

	</ul>

</div>
