<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use \WP_Query;

$thumb_size1 = 'fmwave-v3-b';
$thumb_size2 = 'fmwave-v3-s';
$prefix = FMWAVE_CORE_CPT;
$args = array(
	'post_type'  => "{$prefix}_video",
	'posts_per_page' => 5,
	'order'            => $data['post_ordering'],
    'orderby'           => $data['post_orderby'],
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => "{$prefix}_video_category",
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

if ( !empty( $data['fm_post_ids'] ) ) {
	$args['post__in'] = array( $data['fm_post_ids'] );
}

$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query ); ?>

<div class="video-grid <?php echo esc_attr( $data['layout'] ); ?>">
    <div class="row gutters-10">
    <?php
    $i = 1;
    if ($query->have_posts()) {
        while ( $query->have_posts() ) { $query->the_post();
            $get_view = get_post_meta( get_the_ID(), 'video_view' , true );
            $get_length = get_post_meta( get_the_ID(), "{$prefix}_video_length" , true );
            $get_video_link = get_post_meta( get_the_ID(), "{$prefix}_video_link" , true );
            ?>
            <?php if ( $i == 1 ) { ?>
                <div class="col-lg-6">

                    <div class="video-box">
                        <?php if ( has_post_thumbnail() ){ ?>
                            <?php the_post_thumbnail( $thumb_size1 );?>
                        <?php }	?>
                        <div class="video-icon icon-lg">
                            <a class="play-btn popup-youtube" href="<?php echo esc_url( $get_video_link); ?>">
                                <i class="fas fa-play"></i>
                            </a>
                        </div>
                    </div>

                </div>
                <?php } ?>
                <?php if ( ( $i == 2 ) ) { ?>
                    <div class="col-lg-6">

                        <div class="row gutters-10">
                            <?php } ?>
                            <?php if ( $i > 1 ){ ?>
                            <div class="col-sm-6">

                                <div class="video-box">
                                    <?php if ( has_post_thumbnail() ){ ?>
                                        <?php the_post_thumbnail( $thumb_size2 );?>
                                    <?php }	?>
                                    <div class="video-icon">
                                        <a class="play-btn popup-youtube" href="<?php echo esc_url( $get_video_link); ?>">
                                            <i class="fas fa-play"></i>
                                        </a>
                                    </div>
                                </div>

                            </div>
                            <?php } ?>
                          <?php if ( $i == 5 ) { ?>
                        </div>

                    </div>
                <?php } ?>
        <?php $i++; }
    } else { ?>
        <div class="text-center"><?php esc_attr_e('No Video Found' , 'fmwave-core'); ?></div>
    <?php } ?>
    <?php Helper::wp_reset_temp_query( $temp );?>
    </div>
	<?php if ( !empty($data['button_text']) ) { ?>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="more-video-btn">
                    <a href="<?php echo esc_html( $data['button_url'] ); ?>" class="item-btn"><?php echo esc_html( $data['button_text'] ); ?></a>
                </div>
            </div>
        </div>
    </div>
	<?php } ?>
</div>