<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use \WP_Query;

$thumb_size = 'fmwave-show-isotope';
$prefix = FMWAVE_CORE_CPT;

if ( get_query_var('paged') ) {
    $paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
    $paged = get_query_var('page');
}
else {
    $paged = 1;
}

$args = array(
	'post_type'  		=> "{$prefix}_video",
	'posts_per_page' 	=> $data['number'],
	'order' 			=> $data['post_ordering'],
	'orderby' 			=> $data['post_orderby'],
	'paged'          => $paged, 
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => "{$prefix}_video_category",
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

if ( !empty( $data['fm_post_ids'] ) ) {
	$args['post__in'] = array( $data['fm_post_ids'] );
}

$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query ); ?>

<div class="video-story">
    <div class="row justify-content-center">
		<?php
		if ($query->have_posts()) {
			while ( $query->have_posts() ) { $query->the_post();
				$get_length = get_post_meta( get_the_ID(), "{$prefix}_video_length" , true );
				$get_video_link = get_post_meta( get_the_ID(), "{$prefix}_video_link" , true );
				?>
                <div class="<?php echo esc_attr( $col_class ); ?>">
                    <div class="video-box">
                        <div class="item-img">
                            <?php if ( has_post_thumbnail() ){ ?>
                                <?php the_post_thumbnail( $thumb_size );?>
                            <?php }	?>
                            <div class="video-icon">
                                <a class="play-btn popup-youtube" href="<?php echo esc_url( $get_video_link); ?>">
                                    <i class="fas fa-play"></i>
                                </a>
                            </div>
                        </div>
						<?php if(!empty($data['show_length']) || !empty($data['show_count']) || !empty($data['title_style'])) { ?>
                        <div class="item-content">
                            <?php if ( 'yes' == $data['title_style'] ) { ?><h3 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3><?php } ?>
                            <ul class="entry-meta">
                                <?php if ( ( 'yes' == $data['show_length'] ) && ( !empty( $get_length ) ) ) { ?>
								<li><i class="far fa-clock"></i><?php echo esc_html( $get_length ); ?></li>
								<?php } if ( 'yes' == $data['show_count'] && function_exists( 'fmwave_views' ) ) { ?>
								<li><i class="far fa-eye"></i><?php echo fmwave_views(); ?></li>
								<?php } ?>
                            </ul>
							
                        </div>
						<?php } ?>
                    </div>
                </div>
			<?php }			
		} else { ?>
            <div class="text-center"><?php esc_attr_e('No Video Found' , 'fmwave-core'); ?></div>
        <?php } ?>        
    </div>
    <?php Helper::pagination(); ?>
	<?php Helper::wp_reset_temp_query( $temp );?>
</div>