<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;
use Elementor\Group_Control_Image_Size;
use \WP_Query;

$thumb_size = 'fmwave-blog-single';
$prefix = FMWAVE_CORE_CPT;
$args = array(
    'post_type'  => "{$prefix}_video",
	'posts_per_page' => 1,
	'order'            => $data['post_ordering'],
    'orderby'           => $data['post_orderby'],
);
if ( !empty( $data['fm_post_id'] ) ) {
	$args['p'] = $data['fm_post_id'];
}

$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query ); ?>

<div class="video-story">
    <div class="row justify-content-center">
<?php
if ($query->have_posts()) {
	while ( $query->have_posts() ) { $query->the_post();
	$get_length = get_post_meta( get_the_ID(), "{$prefix}_video_length" , true );
	$get_video_link = get_post_meta( get_the_ID(), "{$prefix}_video_link" , true );
	?>
        <div class="col-lg-8">
            <div class="video-box video-box-light">
                <div class="item-img">
                    <?php if ( has_post_thumbnail() ){ ?>
                        <?php the_post_thumbnail( $thumb_size );?>
                    <?php }	?>
                </div>
                <div class="item-content">
                    <div class="video-icon">
                        <a class="play-btn popup-youtube" href="<?php echo esc_url( $get_video_link); ?>">
                            <i class="fas fa-play"></i>
                        </a>
                    </div>
                    <?php if ( 'yes' == $data['title_style'] ) { ?><h3 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3><?php } ?>
                    <ul class="entry-meta">
						<?php if ( ( 'yes' == $data['show_length'] ) && ( !empty( $get_length ) ) ) { ?>
                        <li><i class="far fa-clock"></i><?php echo esc_html( $get_length ); ?></li>
                        <?php } if ( 'yes' == $data['show_count'] && function_exists( 'fmwave_views' ) ) { ?>
                        <li><i class="far fa-eye"></i><?php echo fmwave_views(); ?></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php }
} ?>
    <?php Helper::wp_reset_temp_query( $temp );?>
    </div>
</div>