<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use \WP_Query;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;
?>
<?php
	$selected_shows = $data['posts_selected_show'];
	$posts_id_holder = array();
    foreach ( $selected_shows as $selected_show ){
	    $posts_id_holder[] = $selected_show['post_list'];
    }
	
	$thumb_size = 'fmwave-v3-b';
	$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
?>
<section class="default-upcoming upcoming-show">
	<div class="row">
		<?php
			$today_weekday = strtolower(date('D'));
			$today_time = date('g:i a');
			$time_now = esc_html (strtotime((str_replace( ' ', '', ($today_time)))));
			
			$prefix = FMWAVE_CORE_CPT;
			$args = array(
				'posts_per_page' => $data['number'],
				'post_type' => "{$prefix}_show",
				'post__in' => $posts_id_holder,
			);

			$query = new WP_Query( $args );
			$temp = Helper::wp_set_temp_query( $query );
		?>
		<?php if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
	
				$metas = get_post_meta( get_the_ID(), "{$prefix}_show_schedule", true );
				$day_name = wp_list_pluck( $metas, 'week' );
				$pointer = array_search( $today_weekday , $day_name );

				//next show start
				$today = '';
				switch ( current_time("l") ) {
					case 'Monday':
						$today = 'mon';
						break;

					case 'Tuesday':
						$today = 'tue';
						break;

					case 'Wednesday':
						$today = 'wed';
						break;

					case 'Thursday':
						$today = 'thu';
						break;

					case 'Friday':
						$today = 'fri';
						break;

					case 'Saturday':
						$today = 'sat';
						break;

					case 'Sunday':
						$today = 'sun';
						break;  
				}   
				$schedules = get_post_meta( get_the_ID(), "{$prefix}_show_schedule", true );

				$current_time = '';

				if ( $schedules ) {
					foreach ($schedules as $schedule) {
						if ( $schedule['week'] == $today ) { 
							$current_time = $schedule['start_time'];
						} 
					}
				}				
				//next show end
				
				$start_time = !empty( $current_time ) ? strtotime( $current_time ) : false;
				$start_time = $start_time ? date( get_option('time_format'), $start_time ) : '';
		
		?>
		<div class="<?php echo esc_attr( $col_class ); ?>">
			<div class="show-box">
				<div class="item-img">
					<?php the_post_thumbnail($thumb_size); ?>
				</div>
				<div class="item-date"><?php echo esc_html( $start_time ); ?></div>
				<div class="item-content">
					<h3 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
					<div class="host-name"><?php echo get_the_title( $metas[0]['team']); ?></div>
				</div>
			</div>
		</div>
			 <?php
			}
		} ?>
		<?php Helper::wp_reset_temp_query( $temp );?>
	</div>
</section>