<?php

/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use \WP_Query;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;

extract($data);
?>
<?php
$selected_shows = $data['posts_selected_show'];
$posts_id_holder = array();
foreach ($selected_shows as $selected_show) {
	$posts_id_holder[] = $selected_show['post_list'];
}

$weeknames = array(
	'mon' => esc_html__('Monday', 'fmwave'),
	'tue' => esc_html__('Tuesday', 'fmwave'),
	'wed' => esc_html__('Wednesday', 'fmwave'),
	'thu' => esc_html__('Thursday', 'fmwave'),
	'fri' => esc_html__('Friday', 'fmwave'),
	'sat' => esc_html__('Saturday', 'fmwave'),
	'sun' => esc_html__('Sunday', 'fmwave'),
);
$weeknames = apply_filters('fmwave_weeknames', $weeknames);

$thumb_size = 'fmwave-event-grid';

$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
?>
<section class="default-upcoming upcoming-dynamic2">
	<div class="row">
		<?php
		//next show start
		$today = Helper::get_today();

		$today_weekday = strtolower(date('D'));
		$today_time = date('g:i a');
		$time_now = esc_html(strtotime((str_replace(' ', '', ($today_time)))));

		$prefix = FMWAVE_CORE_CPT;
		$args = array(
			'posts_per_page' => $data['number'],
			'post_type' => "{$prefix}_show",
			'post__in' => $posts_id_holder,
			'fields' => 'ids'
		);

		$query = new WP_Query($args);

		$rawIds = [];

		if (!empty($query->posts)) {
			foreach ($query->posts as $id) {
				$metas = get_post_meta($id, "{$prefix}_show_schedule", true);
				$day_name = wp_list_pluck($metas, 'week');

				//next show start
				$current_day = false;
				$next_day = $next_time = $next_day_name = '';

				if ($metas) {
					$i = 1;
					$has_next_day = true;
					$total_schedule = count($metas);
					foreach ($metas as $schedule) {
						if ($current_day) {
							$next_day = $schedule['week'];
							$next_time = $schedule['start_time'];
							break;
						}

						if ($schedule['week'] == $today) {

							if (strtotime($schedule['start_time']) > strtotime(current_time('H:i'))) {
								$next_day = $schedule['week'];
								$next_time = $schedule['start_time'];
								break;
							} else {
								$current_day = true;
								if ($total_schedule == $i) {
									$has_next_day = false;
								}
							}
						}
						$i++;
					}
				}

				if (!$has_next_day) {
					$next_day_name = $weeknames[$metas[0]['week']];
					$next_day = $metas[0]['week'];
					$next_time = $metas[0]['start_time'];
				} else {
					if (isset($weeknames[$next_day])) {
						$next_day_name = $weeknames[$next_day];
					}
				}
				//next show end

				$start_time = !empty($next_time) ? strtotime($next_time) : false;
				$start_time = $start_time ? date(get_option('time_format'), $start_time) : '';

				$rawIds[$id] = [
					'day' => array_search($next_day, array_keys($weeknames)),
					'time' => $next_time
				];
			}
		}

		$rawIds = Helper::array_sort($rawIds, 'day');
		$timeSortIds = [];
		foreach($rawIds as $id => $postData){
			$timeSortIds[$postData['day']][$id]=$postData;
		}
		$postIds = [];
		foreach($timeSortIds as $sortedIds){
			if(count($sortedIds) > 1){
				$postIds = $postIds + Helper::array_sort($sortedIds, 'time');
			}else{
				$postIds = $postIds + $sortedIds;
			}
		}

		?>
		<?php if (!empty($postIds)) {
			foreach ($postIds as $id => $timeShedule) {
				global $post;
				$post = get_post($id);
				setup_postdata($post);
				$start_time = !empty($timeShedule['time']) ? strtotime($timeShedule['time']) : false;
				$start_time = $start_time ? date(get_option('time_format'), $start_time) : '';
				$next_day_name = $weeknames[array_keys($weeknames)[$timeShedule['day']]];
				$metas = get_post_meta(get_the_ID(), "{$prefix}_show_schedule", true);

		?>
				<div class="<?php echo esc_attr($col_class); ?>">
					<div class="show-box">
						<div class="item-img">
							<?php the_post_thumbnail($thumb_size); ?>
							<div class="item-date">
								<span class="next-day"><i class="far fa-calendar"></i><?php echo esc_html($next_day_name); ?></span>
								<span class="next-time"><i class="far fa-clock"></i><?php echo esc_html($start_time); ?></span>
							</div>
						</div>

						<div class="item-content">
							<div class="item-info">
								<h3 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
								<div class="host-name"><?php echo get_the_title($metas[0]['team']); ?></div>
							</div>
						</div>
					</div>
				</div>
		<?php
				wp_reset_postdata();
			}
		} ?>
	</div>
</section>