<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\fmwave\RDTheme;
use radiustheme\Fmwave\Helper;
use \WP_Query;

$thumb_size     = "fmwave-v3-b";
$prefix = FMWAVE_CORE_CPT;

if ( get_query_var('paged') ) {
    $paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
    $paged = get_query_var('page');
}
else {
    $paged = 1;
}

$args = array(
    'post_type'         => "{$prefix}_tvshow",
    'posts_per_page'    => $data['number'],
    'order'             => $data['post_ordering'],
    'orderby'           => $data['post_orderby'],
    'paged'          => $paged, 
);

if ( !empty( $data['cat'] ) ) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => "{$prefix}_tvshow_category",
            'field' => 'term_id',
            'terms' => $data['cat'],
        )
    );
}

$query = new WP_Query( $args );
$slider_nav_class = $data['slider_nav'] == 'yes' ? 'slider-nav-enabled' : '';
$slider_dot_class = $data['slider_dots'] == 'yes' ? ' slider-dot-enabled' : '';
$temp = Helper::wp_set_temp_query( $query ); ?>

<div class="tv-movie-1 owl-wrap rt-owl-nav-2 tv-movie-slider-<?php echo esc_attr( $data['layout'] );?> <?php echo esc_attr( $slider_nav_class );?> <?php echo esc_attr( $slider_dot_class );?>">
    <div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $data['owl_data'] );?>">
        <?php
        if ($query->have_posts()) {
            while ( $query->have_posts() ) { $query->the_post();
                $id             = get_the_id();
                $tv_year        = get_post_meta( $id, "{$prefix}_tvshow_year", true );
                $tv_imbd        = get_post_meta( $id, "{$prefix}_tvshow_imdb", true );
                $get_video_link = get_post_meta( get_the_ID(), "{$prefix}_tvshow_video_link" , true );
                $title = wp_trim_words(get_the_title(), $data['title_count'], '');

                $comments_number = number_format_i18n( get_comments_number() );
                $comments_html  = $comments_number;
             ?>
                    <div class="tvshow-box">
                        <div class="item-img">
                            <?php the_post_thumbnail( $thumb_size ); ?>
                            <?php if( $get_video_link ) { ?>
                            <div class="video-icon">
                                <a class="play-btn popup-youtube" href="<?php echo esc_url( $get_video_link ); ?>">
                                    <i class="fas fa-play"></i>
                                </a>
                            </div>
                            <?php } ?>
                        </div>
                        <div class="item-content">
                            <?php if( $tv_year && $data['year_display'] == 'yes' ) { ?>
                            <div class="item-year"><?php echo esc_html( $tv_year ); ?></div>
                            <?php } ?>
                            <h3 class="item-title"><a href="<?php the_permalink();?>"><?php echo wp_kses_post( $title ); ?></a></h3>
                            <div class="rating-comment">
                                <?php if( $tv_imbd && $data['rating_display'] == 'yes' ) { ?>
                                <div class="item-rating"><i class="fas fa-star"></i><?php echo esc_html( $tv_imbd ); ?></div>
                                <?php } if( $data['comment_display'] == 'yes' ) { ?>
                                <div class="item-comment"><i class="far fa-comment-dots"></i><?php echo esc_html( $comments_html ); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
            <?php }
            
        } else { ?>
            <div class="text-center"><?php esc_attr_e('No TV Show Found' , 'fmwave-core'); ?></div>

        <?php } ?>
    </div>
    <?php Helper::wp_reset_temp_query( $temp );?>
</div>