<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\fmwave\RDTheme;
use radiustheme\Fmwave\Helper;
use \WP_Query;

$thumb_size     = "fmwave-v3-b";
$prefix = FMWAVE_CORE_CPT;

if ( get_query_var('paged') ) {
    $paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
    $paged = get_query_var('page');
}
else {
    $paged = 1;
}

$args = array(
    'post_type'         => "{$prefix}_tvshow",
    'posts_per_page'    => $data['number'],
    'order'             => $data['post_ordering'],
    'orderby'           => $data['post_orderby'],
    'paged'          => $paged, 
);

if ( !empty( $data['cat'] ) ) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => "{$prefix}_tvshow_category",
            'field' => 'term_id',
            'terms' => $data['cat'],
        )
    );
}

$query = new WP_Query( $args );
$slider_nav_class = $data['slider_nav'] == 'yes' ? 'slider-nav-enabled' : '';
$slider_dot_class = $data['slider_dots'] == 'yes' ? ' slider-dot-enabled' : '';
$temp = Helper::wp_set_temp_query( $query ); 

?>

<div class="tv-hero-slider owl-wrap rt-owl-nav-2 <?php echo esc_attr( $slider_nav_class );?> <?php echo esc_attr( $slider_dot_class );?>">
    <div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $data['owl_data'] );?>">
        <?php
        if ($query->have_posts()) {
            while ( $query->have_posts() ) { $query->the_post();
                $id             = get_the_id();
                $tv_direcor     = get_post_meta( $id, "{$prefix}_tvshow_director", true );
                $tv_imbd        = get_post_meta( $id, "{$prefix}_tvshow_imdb", true );
                $get_video_link = get_post_meta( get_the_ID(), "{$prefix}_tvshow_video_link" , true );
                $tv_slider_img = get_post_meta( get_the_ID(), "{$prefix}_tv_slider" , true );
                $title = wp_trim_words(get_the_title(), $data['title_count'], '');
             ?>
                <div class="hero-box">
                    <div class="item-img">
                        <?php if ( !empty($tv_slider_img )) { ?>
                            <?php
                                $image_size = 'full';
                                $alt_text   = trim( wp_strip_all_tags( get_post_meta( $tv_slider_img, '_wp_attachment_image_alt', true ) ) );
                                echo wp_get_attachment_image( $tv_slider_img, $image_size,  false,    array(
                                        'class'     => 'wp-post-image',
                                        'alt'       => esc_attr( $alt_text )
                                    )
                                );

                            } else { ?>
                                <?php the_post_thumbnail( $image_size ); ?>
                        <?php } ?>                        
                    </div>
                    <div class="item-content">
                        <div class="container">
                            <?php if( $data['category_display'] == 'yes' ) { ?> 
                            <?php
                            $term_lists = get_the_terms( get_the_ID(), "{$prefix}_tvshow_category" );
                            if($term_lists){ ?>
                            <div class="cat-list">
                                <?php foreach ( $term_lists as $term_list ){ 
                                $link = get_term_link( $term_list->term_id, "{$prefix}_tvshow_category" ); ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php  } ?>
                            </div>  
                            <?php } } ?>
                            <?php if( $data['director_display'] == 'yes' ) { ?>                  
                            <div class="item-director"><?php esc_attr_e('Director: ' , 'fmwave-core'); ?><?php echo esc_html( $tv_direcor ); ?></div>
                            <?php } ?>
                            <h3 class="item-title"><a href="<?php the_permalink();?>"><?php echo wp_kses_post( $title ); ?></a></h3>
                            <?php if( $tv_imbd && $data['rating_display'] == 'yes' ) { ?>
                            <div class="item-rating"><span><?php esc_attr_e('Imdb: ' , 'fmwave-core'); ?></span><?php echo esc_html( $tv_imbd ); ?></div>
                            <?php } ?>
                            <?php if( $get_video_link && $data['video_display'] == 'yes' ) { ?>
                            <div class="video-icon">
                                <a class="play-btn popup-youtube" href="<?php echo esc_url( $get_video_link ); ?>">
                                    <i class="fas fa-play-circle"></i><?php esc_attr_e('Watch Trailer' , 'fmwave-core'); ?>
                                </a>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php }            
        } else { ?>
            <div class="text-center"><?php esc_attr_e('No TV Show Found' , 'fmwave-core'); ?></div>

        <?php } ?>
    </div>
    <?php Helper::wp_reset_temp_query( $temp );?>
</div>