<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */


namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Group_Control_Image_Size;
use \WP_Query;

$prefix = FMWAVE_CORE_CPT;

$track_image_size = 'fmwave-team-1' ;

    $args = array(
        'post_type'  => "{$prefix}_music",
		'posts_per_page' => 1,
    );

     if ( !empty( $data['fm_track_ids'] ) ) {
        $args['p'] = $data['fm_track_ids'];
    }

    $query = new WP_Query( $args );
    $temp = Helper::wp_set_temp_query( $query );
?>
<div class="music-channel">
<?php
    if ($query->have_posts()) {
        while ( $query->have_posts() ) { $query->the_post();
            $get_audio_track = get_post_meta( get_the_ID(), "{$prefix}_track" , true );
            $get_track_image = get_post_meta( get_the_ID(), "{$prefix}_track_image" , true );
            $get_track_album = get_post_meta( get_the_ID(), "{$prefix}_track_album" , true );
            $get_artist = get_post_meta( get_the_ID(), "{$prefix}_artist" , true );
			$auto_start_option = $data['fm_track_ids'];
			$team_socials       	= get_post_meta( get_the_ID(), "{$prefix}_music_social", true );
			$social_fields 	= Helper::team_socials();
			
            ?>
              <div class="music-box">
                <div class="channel-content">
                    <div class="item-img">
                        <?php $thumbnail_url = wp_get_attachment_image_src($get_track_image, array('350','385'), true );  ?>
                        <img src="<?php echo $thumbnail_url[0]; ?>" width="239" height="272" loading="lazy" alt="<?php the_title_attribute(); ?>">
                        <div class="top-content">
                            <div class="item-heading">
                                <h3 class="item-title"><?php the_title(); ?></h3>
                                <div class="item-subtitle"><?php esc_html_e( $get_artist ); ?></div>
                            </div>
                            <div class="video-icon">
                                <audio <?php if ( $auto_start_option == 'on' ) { ?>autoplay<?php } ?> class="fmwave-audio-plybtn" >
                                    <source src="<?php echo wp_get_attachment_url( $get_audio_track ); ?>" type="audio/mp3">
                                </audio>
                            </div>
                            <ul class="action-icon">
                                <li><a href="<?php the_permalink(); ?>"><i class="fas fa-info"></i></a></li>
								<?php if ( !empty( $team_socials ) ){ ?>
                                <li class="share-list">
                                    <a href="#"><i class="fas fa-share-alt"></i></a>
                                    <ul class="share-icon">                                        
										<?php foreach ( $team_socials as $key => $social ){
											if ( !empty( $social ) ){ ?>
												<li><a target="_blank" href="<?php echo esc_url( $social );?>"><i class="fab <?php echo esc_attr( $social_fields[$key]['icon'] );?>" aria-hidden="true"></i></a></li>
											<?php } ?>
										<?php } ?>
                                    </ul>
                                </li>
								<?php } ?>
                            </ul>
                        </div>
                    </div>
                    <div class="item-content">
                        <?php
                            $terms = get_the_terms( get_the_ID(), "{$prefix}_music_album");
                            if ( $terms && ! is_wp_error( $terms ) ) {
                                $draught_links = array();
                                foreach ( $terms as $term ) {
                                    $draught_links[] = $term->name;
                                }
                                $albums = join( ", ", $draught_links );
                        ?>
                        <h3 class="item-title"><?php printf( esc_html__( '%s ', 'fmwave-core' ), esc_html( $albums ) ); ?></h3>
                        <?php } ?>
                        <?php the_excerpt(); ?>
                    </div>
                </div>
                <div class="disck-img">
                    <img width="271" height="271" src="<?php echo wp_get_attachment_url( $get_track_album ); ?>" loading="lazy" alt="<?php the_title_attribute(); ?>">
                </div>
            </div>
        <?php }
    } else { ?>
        <div class="text-center"><?php esc_attr_e('No Audio/Track Found' , 'fmwave-core'); ?></div>
    <?php } ?>
        <?php Helper::wp_reset_temp_query( $temp );?>
</div>