<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Group_Control_Image_Size;
use \WP_Query;

$prefix = FMWAVE_CORE_CPT;

    $args = array(
        'post_type'  => "{$prefix}_music",
        'posts_per_page' => 1,
    );

     if ( !empty( $data['fm_track_ids'] ) ) {
        $args['post__in'] = array( $data['fm_track_ids'] );
    }

    $query = new WP_Query( $args );
    $temp = Helper::wp_set_temp_query( $query );

    if ($query->have_posts()) {
        while ( $query->have_posts() ) { $query->the_post();
            $get_audio_length = get_post_meta( get_the_ID(), "{$prefix}_track_length" , true );
            $get_audio_track = get_post_meta( get_the_ID(), "{$prefix}_track" , true );
            $get_artist = get_post_meta( get_the_ID(), "{$prefix}_artist" , true );
            $get_release_day = get_post_meta( get_the_ID(), "{$prefix}_release_day" , true );

            $get_produce = get_post_meta( get_the_ID(), "{$prefix}_produce" , true );

			$auto_start_option = get_post_meta( get_the_ID(), "auto_start_option" , true );

            ?>

            <div class="rt-audio-player-wrap">
                <div class="container">
                    <div class="player-box">
                        <div class="song-name">
                            <h3 class="item-title"><span><?php the_title(); ?></span><?php esc_html_e( $get_artist ); ?></h3>
                        </div>
                        <div class="audio-player">
                            <audio <?php if ( $auto_start_option == 'on' ) { ?>autoplay<?php } ?> class="fmwave-audio-full-track" >
                                <source src="<?php echo wp_get_attachment_url( $get_audio_track ); ?>" type="audio/mp3">
                            </audio>
                        </div>
                    </div>
                </div>
            </div>
        <?php }
    } else { ?>
        <div class="text-center"><?php esc_attr_e('No Audio/Track Found' , 'fmwave-core'); ?></div>
    <?php } ?>
        <?php Helper::wp_reset_temp_query( $temp );?>