<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use \WP_Query;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;

$prefix      = FMWAVE_CORE_THEME;
$cpt         = FMWAVE_CORE_CPT;
$thumb_size  = "fmwave-size-team2";
$args = array(
	'post_type'      => "{$cpt}_team",
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
);
if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => "{$cpt}_team_category",
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}
switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}
$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query );
?>
<div class="team-default-layout team-modern">
    <div class="row">
        <?php if ( $query->have_posts() ) :?>
        <?php while ( $query->have_posts() ) : $query->the_post();?>
        <?php
			$id            	= get_the_id();
			$show_name   	= get_post_meta( $id, "{$cpt}_show_name", true );
			$show_date   	= get_post_meta( $id, "{$cpt}_show_date", true );
			$socials       	= get_post_meta( $id, "{$cpt}_team_social", true );
			$social_fields 	= Helper::team_socials();
			$content = apply_filters( 'the_content', get_the_content() );
			$content 		= wp_trim_words( $content, $data['count'], '' );
			$content 		= "<p>$content</p>";
        ?>
        <div class="<?php echo esc_attr( $col_class );?>">
            <div class="team-box">
                <?php if ( has_post_thumbnail() ){ ?>
                    <div class="item-img"><?php the_post_thumbnail( $thumb_size ); ?></div>
                <?php } ?>
                <div class="item-content">
                    <h3 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
					<?php if ( $data['show_display']  == 'yes' ) { ?>
                    <div class="item-subtitle"><?php echo esc_html ($show_name); ?></div>
					<?php } ?>
					<?php if ( $data['content_display']  == 'yes' ) { ?>
						<?php echo wp_kses_post( $content );?>
					<?php } ?>
                    <div class="item-time"><?php echo esc_html ($show_date); ?></div>
                    <?php if ( !empty( $data['item_social'] ) ){ ?>
                        <div class="item-social">
                            <?php foreach ( $socials as $key => $social ) { ?>
                                <?php if ( !empty( $social ) ){ ?>
                                    <a target="_blank" href="<?php echo esc_url( $social );?>"><i class="fab <?php echo esc_attr( $social_fields[$key]['icon'] );?>" aria-hidden="true"></i></a>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php endwhile; ?>
    <?php endif; ?>
    <?php Helper::wp_reset_temp_query( $temp ); ?>
    </div>
</div>
