<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
extract( $data );
/*breaking the foreach*/
$banners = array();
foreach ( $data['banner_list'] as $banner_list ) {
	$banners[] = array(
		'id'           		=> 'testimonial-' . time().rand( 1, 99 ),
		'banner_image'      => $banner_list['banner_image']['id'] ? $banner_list['banner_image']['id'] : "",
		'banner_text'       => $banner_list['banner_text'],
		'button_text'     	=> $banner_list['button_text'],
		'button_url'        => $banner_list['button_url']['url'],
		
		'show_time'        => $banner_list['show_time'],
		'show_title'        => $banner_list['show_title'],
	);
}

?>

<div class="slider-area slider-layout1">
    <div class="bend niceties preview-1">
        <div id="ensign-nivoslider-3" class="slides">
			<?php $i = 1; foreach ( $banners as $banner ) { 
				$attr = array('title' => '#slider-direction-'.$i );
				$banner_image = wp_get_attachment_image( $banner['banner_image'], 'full', false, $attr );
			?>
				<?php echo wp_kses_post( $banner_image ); ?>
            <?php $i++; } ?>
        </div>

		<?php $y = 1; foreach ( $banners as $banner ) { ?>
        <div id="slider-direction-<?php echo esc_attr( $y ); ?>" class="t-cn slider-direction">
            <div class="slider-content s-tb slide-<?php echo esc_attr( $y ); ?>">
                <div class="text-left title-container s-tb-c">
                    <div class="container-fluid">
                        <h1 class="slider-big-text"><?php echo $banner['banner_text']; ?></h1>
                        <div class="slider-btn-area">
                            <a href="<?php echo esc_url( $banner['button_url'] ); ?>" class="item-btn"><?php echo wp_kses( $banner['button_text'], 'alltext_allow' ); ?></a>
                        </div>
                    </div>
                </div>
            </div>
			<?php if ( !empty( $banner['show_time'] ) && !empty( $banner['show_title'] ) ) { ?>
			<div class="show-details">
				<div class="show-time"><?php echo esc_html( $banner['show_time'] ); ?></div>
				<div class="show-title"><?php echo wp_kses( $banner['show_title'] , 'alltext_allow' ); ?></div>
			</div>
			<?php } ?>
        </div>
        <?php $y++; } ?>
    </div>
</div>