<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
extract($data);

if( !empty( $data['price'] )){
	$price_html  = '<span class="price-symbol">' . $data['price_symbol'] . '</span>' . $data['price'] . '<span class="price-unit"> / '. $data['unit'] . '</span>';
} else {
	$price_html = '';
}

$attr = '';
if ( !empty( $data['buttonurl']['url'] ) ) {
	$attr  = 'href="' . $data['buttonurl']['url'] . '"';
	$attr .= !empty( $data['buttonurl']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['buttonurl']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $attr . '>' . $data['title'] . '</a>';
	
}

// icon , image
$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'icon_image' );

$price_icon_class       = " ";
$price_icon_image_url   = '';
if ( is_string( $icon_class['value'] ) && $dynamic_icon_class2 =  $icon_class['value']  ) {
  $price_icon_class     = $dynamic_icon_class2;
}
if ( is_array( $icon_class['value'] ) ) {
  $price_icon_image_url = $icon_class['value']['url'];
}

?>

<div class="default-pricing pricing-layout-1">		
	<div class="item-box">
		<?php if ($data['icon_display'] == 'yes') { ?>
		<div class="item-icon">			
			<?php if ( !empty( $data['icontype']== 'image' ) ) { ?>		            
				<span class="rt-img"><?php echo wp_kses_post($getimg);?></span>  
			<?php }else{?> 	
			<?php if ( $price_icon_image_url ): ?>
				<span class="rt-icon"><img src="<?php echo esc_url( $price_icon_image_url ); ?>" alt="SVG Icon"></span>
			<?php else: ?>
				<i class="<?php echo esc_attr( $price_icon_class ); ?>"></i>
			<?php endif ?>
			<?php }  ?>	
		</div>
		<?php } ?>
		<div class="price-header">
			<?php if ( !empty( $data['sub_title'] )) { ?>
			<div class="rt-sub-title"><?php echo wp_kses_post( $sub_title );?></div>
			<?php } if ( !empty( $data['title'] )) { ?>
			<h3 class="rt-title"><?php echo esc_html( $data['title'] );?></h3>
			<?php } ?>
			<div class="rt-price"><?php echo wp_kses_post( $price_html );?></div>
		</div>
		<ul class="rt-features">
		  <?php foreach ($data['list_feature'] as $feature): ?>
			<li>
			  <?php
			  extract($feature);
				$final_icon_class       = "";
				$final_icon_image_url   = '';
				if ( is_string( $list_icon_class['value'] ) && $dynamic_icon_class =  $list_icon_class['value']  ) {
				  $final_icon_class     = $dynamic_icon_class;
				}
				if ( is_array( $list_icon_class['value'] ) ) {
				  $final_icon_image_url = $list_icon_class['value']['url'];
				}
			  ?>
			  <?php if ($data['has_icon'] == 'yes'): ?>
				<?php if ( $final_icon_image_url ): ?>
				  <img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon">
				<?php else: ?>
				  <i style="color: <?php echo esc_attr( $list_icon_color ); ?>"  class="<?php echo esc_attr( $final_icon_class ); ?>"></i>
				<?php endif ?>
			  <?php endif ?>
			  <span class="rt-features-text"><?php echo esc_html( $feature['text'] ); ?></span>
			</li>
		  <?php endforeach ?>
		</ul>		
		<?php if ( !empty( $data['buttontext'] ) ){ ?>
			<div class="rt-price-button">
				<a class="rt-item-btn" <?php echo $attr; ?>><?php echo esc_html( $data['buttontext'] );?></a>
			</div>		
		<?php } ?>
	</div>			
</div>