<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\fmwave\RDTheme;
use radiustheme\Fmwave\Helper;
use \WP_Query;

$thumb_size     = "fmwave-v3-b";
$prefix = FMWAVE_CORE_CPT;

if ( get_query_var('paged') ) {
    $paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
    $paged = get_query_var('page');
}
else {
    $paged = 1;
}

$args = array(
    'post_type'         => "{$prefix}_podcast",
    'posts_per_page'    => $data['number'],
    'order'             => $data['post_ordering'],
    'orderby'           => $data['post_orderby'],
    'paged'          => $paged, 
);

if ( !empty( $data['cat'] ) ) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => "{$prefix}_podcast_category",
            'field' => 'term_id',
            'terms' => $data['cat'],
        )
    );
}

$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query ); ?>

<div class="podcast-layout-2">
    <div class="row justify-content-center">
        <?php
        if ($query->have_posts()) {
            while ( $query->have_posts() ) { $query->the_post();
                $title = wp_trim_words(get_the_title(), $data['title_count'], '');
                $title_excerpt = wp_trim_words(get_the_excerpt(), $data['excerpt_count'], '.');
                $get_audio_track = get_post_meta( get_the_ID(), "{$prefix}_pod_track" , true );
                $meta_rj = get_post_meta( get_the_ID(), "{$prefix}_pod_team", true);
                if($meta_rj){
                    $team_title = get_the_title($meta_rj);
                }else{
                    $team_title='';
                }                ?>
                <div class="<?php echo esc_attr( $col_class ); ?>">
                    <div class="podcast-box-2">
                        <div class="item-img">
                            <a href="<?php the_permalink();?>"><?php the_post_thumbnail( $thumb_size ); ?></a>
                        </div>
                        <div class="item-content">
                            <h3 class="item-title"><a href="<?php the_permalink();?>"><?php echo wp_kses_post( $title ); ?></a></h3>
                            <?php if($team_title){ ?>
                            <div class="host-name"><?php echo esc_html( $team_title ); ?></div>
                            <?php } ?>

                            <?php echo wp_kses_post( $title_excerpt ); ?>

                            <?php if( $get_audio_track ) { ?>
                            <div class="item-action" data-post-id="<?php echo esc_attr( get_the_ID() ); ?>"><audio  class="fmwave-audio-plybtn" ><source src="<?php echo wp_get_attachment_url( $get_audio_track ); ?>" type="audio/mp3"></audio><?php esc_attr_e('Play' , 'fmwave-core'); ?></div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php }
            
        } else { ?>
            <div class="text-center"><?php esc_attr_e('No Podcast Found' , 'fmwave-core'); ?></div>

        <?php } ?>
    </div>
    <?php if( $data['pod_pagination'] == 'yes' ) { ?>
        <?php Helper::pagination(); ?>
    <?php } ?>
    <?php Helper::wp_reset_temp_query( $temp );?>
</div>