<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use radiustheme\Fmwave\Helper;

if ( ! defined( 'ABSPATH' ) ) exit;

class icon_Box extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Icon Box', 'fmwave-core' );
		$this->rt_base = 'rt-icon-box';
		parent::__construct( $data, $args );
	}
	public function rt_fields(){
		$fields = array(
	
			array(
					'mode'    => 'section_start',
					'id'      => 'sec_image_icon',
					'label'   => esc_html__( 'Icon', 'fmwave-core' ),				
			),
			 array(
            'type'    => Controls_Manager::CHOOSE,
            'id'      => 'icon-alignment',
            'label'   => esc_html__( 'Style', 'fmwave-core' ),

                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'fmwave-core' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'fmwave-core' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'fmwave-core' ),
                        'icon' => 'fa fa-align-right',
                    ],                   
                ],
                
             'default' => 'left',
            ),
			array(					 
			   'type'    => Controls_Manager::CHOOSE,
			   'options' => [
			     'icon' => [
			       'title' => esc_html__( 'Left', 'fmwave-core' ),
			       'icon' => 'fa fa-smile-o',
			     ],
			     'image' => [
			       'title' => esc_html__( 'Center', 'fmwave-core' ),
			       'icon' => 'fa fa-image',
			     ],		     
			   ],
			   'id'      => 'icontype',
			   'label'   => esc_html__( 'Media Type', 'fmwave-core' ),
			   'default' => 'icon',
			   'label_block' => false,
			   'toggle' => false,				 
			),
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'icon_class',
				'label'   => esc_html__( 'Icon', 'fmwave-core' ),
				'default' => [
			      'value' => 'fas fa-smile-wink',
			      'library' => 'fa-solid',
			  ],	
			  	'condition'   => array('icontype' => array( 'icon' ) ),
			),	
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'icon_image',
				'label'   => esc_html__( 'Image', 'fmwave-core' ),
				'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
				'condition'   => array('icontype' => array( 'image' ) ),
				'description' => esc_html__( 'Recommended full image', 'fmwave-core' ),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'fmwave-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',		
				'condition'   => array('icontype' => array( 'image' ) ),
			),			
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_content',
				'label'   => esc_html__( 'Title / Content', 'fmwave-core' ),
			),
					array(
						'type'    => Controls_Manager::TEXT,
						'id'      => 'title',
						'label'   => esc_html__( 'Title', 'fmwave-core' ),
						'default' => 'Lorem Ipsum',
					),
					array(
						'type'    => Controls_Manager::TEXTAREA,
						'id'      => 'content',
						'label'   => esc_html__( 'Content', 'fmwave-core' ),
						'default' => 'Lorem Ipsum hasbeen standard daand scrambled. Rimply dummy text of the printing and typesetting industry',
					),
					array(
						'type'  				=> Controls_Manager::URL,
						'id'    				=> 'url',
						'label' 				=> esc_html__( 'Link (Optional)', 'fmwave-core' ),
						'placeholder' 	=> 'https://your-link.com',
					),
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_image_style',
				'label'   => esc_html__( 'Image/Icon', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				),

				array(
						'type' 				=> Controls_Manager::SLIDER,
						'mode' 				=> 'responsive',
						'id'      		=> 'icon_box_width',
						'label'   		=> __( 'Icon Box Width', 'fmwave-core' ),
						
						'size_units' => array( 'px' ),		
								'range' => [
				 'px' => [
				   'min' => 0,
				   'max' => 300,
				 ],
				],		
				'default' => array(
				'unit' => 'px',
				'size' => 70,
				),
					'selectors' => array(
						'{{WRAPPER}} .service-box-media .item-icon' => 'width: {{SIZE}}{{UNIT}};',						
					)
				),

				array(
						'type' 				=> Controls_Manager::SLIDER,
						'mode' 				=> 'responsive',
						'id'      		=> 'icon_box_height',
						'label'   		=> __( 'Icon Box Height', 'fmwave-core' ),
						
						'size_units' => array( 'px' ),		
						'range' => [
				 'px' => [
				   'min' => 0,
				   'max' => 300,
				 ],
				],		
				'default' => array(
				'unit' => 'px',
				'size' => 70,
				),
					'selectors' => array(
						'{{WRAPPER}} .service-box-media .item-icon' => 'height: {{SIZE}}{{UNIT}};',						
					)
				),	
				
				array(
					'type' 				=> Controls_Manager::SLIDER,
					'mode' 				=> 'responsive',
					'id'      		=> 'icon_box_padding',
					'label'   		=> __( 'Icon Box Padding', 'fmwave-core' ),
					
					'size_units' => array( 'px' ),		
					'range' => [
				'px' => [
				'min' => 0,
				'max' => 100,
				],
				],		
				'default' => array(
				'unit' => 'px',
				'size' => 10,
				),
					'selectors' => array(
						'{{WRAPPER}} .service-box-media .item-icon' => 'padding: {{SIZE}}{{UNIT}};',						
					)
				),

					array(
						'type' 				=> Controls_Manager::SLIDER,
						'mode' 				=> 'responsive',
						'id'      		=> 'bottom_image_spacing',
						'label'   		=> __( 'Icon Box Spacing', 'fmwave-core' ),						
						'size_units' => array( 'px' ),	
							
						'default' => array(
						'unit' => 'px',
						'size' => 70,
						),
							'selectors' => array(
								'{{WRAPPER}} .service-box-layout2.left .media-body-wrp' => 'padding-left: {{SIZE}}{{UNIT}};',						
								'{{WRAPPER}} .service-box-layout2.center .media-body-wrp' => 'padding-top: {{SIZE}}{{UNIT}};',						
								'{{WRAPPER}} .service-box-layout2.right .media-body-wrp' => 'padding-right: {{SIZE}}{{UNIT}};',						
							)
						),

					array(
						'type'    => Controls_Manager::COLOR,
						'id'      => 'icon_color',
						'label'   => __( 'Icon Color', 'fmwave-core' ),
						'default' => '#fff',						
						'selectors' => array(
								'{{WRAPPER}} .item-icon i:before' => 'color: {{VALUE}}',							
							),
					),	

				array( 
						'mode'      => 'group',
						'type'      => Group_Control_Typography::get_type(),
						'name'      => 'icon_font_size',
						'condition' 	=> [
								'icontype' => 'icon',
								],
						'label'     => esc_html__( 'Icon Typography', 'fmwave-core' ),
						'selector'  => '{{WRAPPER}} .item-icon i',
					),

				array(
					'mode' => 'section_end',
				),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title / Content', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),


			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'bottom_title_spacing',
				'label'   		=> __( 'Bottom Spacing', 'fmwave-core' ),
				'condition' 	=> [
						'button_icon!' => '',
						],
				'size_units' => array( 'px' ),				
				'default' => array(
				'unit' => 'px',
				'size' => 20,
				),
					'selectors' => array(
						'{{WRAPPER}} .item-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',						
					)
				),

			array(
					'type'    => Controls_Manager::COLOR,
					'id'      => 'title_color',
					'label'   => __( 'Title Color', 'fmwave-core' ),
					'default' => '',
					'selectors' => array(
							'{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
							'{{WRAPPER}} .item-title a' => 'color: {{VALUE}}',
						),
				),		
			array(
					'type'    => Controls_Manager::COLOR,
					'id'      => 'title_hover_color',
					'label'   => __( 'Title Hover Color', 'fmwave-core' ),
					'default' => '',
					'selectors' => array(
							'{{WRAPPER}} .item-title:hover' => 'color: {{VALUE}}',
							'{{WRAPPER}} .item-title a:hover' => 'color: {{VALUE}}',
						),
				),	

			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'title_style',
				'label'       =>esc_html__( 'Title Style', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' =>esc_html__( 'Show or Hide Title Style. Default: On', 'fmwave-core' ),
			),	
				array(
					'type'    => Controls_Manager::COLOR,
					'id'      => 'title_style_color',
					'label'   => __( 'Title Style Color', 'fmwave-core' ),
					'default' => '#ee212b',
					'condition'   => array('title_style' => array( 'yes' ) ),
					'selectors' => array(
							'{{WRAPPER}} .title-style::after' => 'background-color: {{VALUE}}',	
							'{{WRAPPER}} .title-style' => 'background-color: {{VALUE}}',	

						),
				),

			array(
			    'type'    => Controls_Manager::CHOOSE,
			    'id'      => 'title_tag',
			    'label'   => esc_html__( 'Title HTML Tag', 'fmwave-core' ),
			    'options' => array(
			        'h1'  => [
			            'title' => esc_html__( 'H1', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h1'
			        ],
			        'h2'  => [
			            'title' => esc_html__( 'H2', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h2'
			        ],
			        'h3'  => [
			            'title' => esc_html__( 'H3', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h3'
			        ],
			        'h4'  => [
			            'title' => esc_html__( 'H4', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h4'
			        ],
			        'h5'  => [
			            'title' => esc_html__( 'H5', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h5'
			        ],
			        'h6'  => [
			            'title' => esc_html__( 'H6', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h6'
			        ],
			        'div'  => [
			            'title' => esc_html__( 'div', 'fmwave-core' ),
			            'icon' => 'eicon-font'
			        ]
			    ),
			    'default' => 'h3',
			    
			),  
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				 'mode'          => 'responsive',
				'id'      => 'content_margin',
				'label'   => __( 'Margin', 'fmwave-core' ),                 
				'selectors' => array(
				    '{{WRAPPER}} .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
				),
			'separator' => 'before',
			),  

			array( 
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'title_typo',
				'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .item-title',
				

			),	
			array(
					'id'  	=> 'hr-1',
					'type'	=> Controls_Manager::DIVIDER,
					'style' => 'thick',
				),
			array( 
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'content_typo',
				'label'     => esc_html__( 'Content Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .item-content',
			 
			),
	
		);
		return $fields;
	}

protected function render() {
	$data = $this->get_settings();	
	
extract($data);
	$attr = '';
	if ( !empty( $data['url']['url'] ) ) {
		$attr  = 'href="' . $data['url']['url'] . '"';
		$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
		$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
		$title = '<a ' . $attr . '>' . $data['title'] . '</a>';
	}
	else {
		$title = $data['title'];
	}

	if ( $attr ) {
	  $getimg = '<a ' . $attr . '>' .Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'icon_image' ).'</a>';
	}
	else {
		$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'icon_image' );
	}

	$final_icon_class       = " fas fa-thumbs-up";
	$final_icon_image_url   = '';
	if ( is_string( $icon_class['value'] ) && $dynamic_icon_class =  $icon_class['value']  ) {
	  $final_icon_class     = $dynamic_icon_class;
	}
	if ( is_array( $icon_class['value'] ) ) {
	  $final_icon_image_url = $icon_class['value']['url'];
	}


		switch ( $data['icon-alignment'] ) {
				case 'left': ?>
						<div class="service-box-layout2 left">
						      <div class="media service-box-media">
										<div class="item-icon">	
											<?php if ( !empty( $data['icontype']== 'image' ) ) { ?>		            
															<?php echo wp_kses_post($getimg);?>  
													<?php }else{?> 	
														<?php if ( $final_icon_image_url ): ?>
																<img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon">
														<?php else: ?>
																<i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i>
														<?php endif ?>
											<?php }  ?>

										</div>
						          <div class="media-body media-body-wrp">
						          	 <<?php echo esc_html( $data['title_tag'] );?> class="item-title"> <?php echo wp_kses_post( $title );?> </<?php echo esc_html( $data['title_tag'] );?>>
														<?php  if ($data['title_style']) { ?>
															<div class="title-style"></div>				
														<?php } ?>
												<?php  if ($data['content']) { ?>
													<p class="item-content"><?php echo wp_kses_post( $data['content'] );?></p>
												<?php } ?>             
						          </div>
						     </div>  
						</div>
				<?php 
				break;
				case 'center': ?>
						<div class="service-box-layout2 center">
						  <div class="service-box-media">
								<div class="item-icon">			
									<?php if ( !empty( $data['icontype']== 'image' ) ) { ?>		            
													<?php echo wp_kses_post($getimg);?>  
											<?php }else{?> 	
												<?php if ( $final_icon_image_url ): ?>
														<img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon">
												<?php else: ?>
														<i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i>
												<?php endif ?>
									<?php }  ?>
								</div>
						      <div class="media-body-wrp">
						      	 <<?php echo esc_html( $data['title_tag'] );?> class="item-title"> <?php echo wp_kses_post( $title );?> </<?php echo esc_html( $data['title_tag'] );?>>
											<?php  if ($data['title_style']) { ?>
													<div class="title-style"></div>				
											<?php } ?>
										<?php  if ($data['content']) { ?>
											<p class="item-content"><?php echo wp_kses_post( $data['content'] );?></p>
										<?php } ?>             
						      </div>
						 </div>  
						</div>
				<?php 
				break;		
				case 'right': ?>
					<div class="service-box-layout2 right">
					  <div class="media service-box-media">
					  	 <div class="media-body media-body-wrp">
					      	 <<?php echo esc_html( $data['title_tag'] );?> class="item-title"> <?php echo wp_kses_post( $title );?> </<?php echo esc_html( $data['title_tag'] );?>>
										<?php  if ($data['title_style']) { ?>
											<div class="title-style"></div>				
										<?php } ?>
									<?php  if ($data['content']) { ?>
										<p class="item-content"><?php echo wp_kses_post( $data['content'] );?></p>
									<?php } ?>             
					      </div>
								<div class="item-icon">			
									<?php if ( !empty( $data['icontype']== 'image' ) ) { ?>		            
													<?php echo wp_kses_post($getimg);?>  
											<?php }else{?> 	
												<?php if ( $final_icon_image_url ): ?>
														<img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon">
												<?php else: ?>
														<i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i>
												<?php endif ?>
									<?php }  ?>
								</div>					     
					 </div>  
					</div>
				<?php 
				break;			
				default: ?>
					<div class="service-box-layout2">
					  <div class="media">
							<div class="item-icon">			
							<?php if ( !empty( $data['icontype']== 'image' ) ) { ?>		            
											<?php echo wp_kses_post($getimg);?>  
									<?php }else{?> 	
										<?php if ( $final_icon_image_url ): ?>
												<img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon">
										<?php else: ?>
												<i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i>
										<?php endif ?>
							<?php }  ?>

						</div>
					      <div class="media-body">
					      	 <<?php echo esc_html( $data['title_tag'] );?> class="item-title"> <?php echo wp_kses_post( $title );?> </<?php echo esc_html( $data['title_tag'] );?>>
										<?php  if ($data['title_style']) { ?>
												<div class="title-style"></div>				
										<?php } ?>
									<?php  if ($data['content']) { ?>
										<p class="item-content"><?php echo wp_kses_post( $data['content'] );?></p>
									<?php } ?>             
					      </div>
					 </div>  
					</div>
				<?php 
				break;
		}
?>


		<?php
	}
}