<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $attr . '>' . $data['title'] . '</a>';
}
else {
	$title = $data['title'];
}
if ( $attr ) {
  $getimg = '<a ' . $attr . '>' .Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'icon_image' ).'</a>';
}
else {
	$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'icon_image' );
}
$final_icon_class       = " fas fa-thumbs-up";
$final_icon_image_url   = '';
if ( is_string( $icon_class['value'] ) && $dynamic_icon_class =  $icon_class['value']  ) {
  $final_icon_class     = $dynamic_icon_class;
}
if ( is_array( $icon_class['value'] ) ) {
  $final_icon_image_url = $icon_class['value']['url'];
}
?>

<div class="icon-box-default icon-box-layout3">
	<div class="icon-box">
		<div class="item-icon">			
			<?php if ( !empty( $data['icontype']== 'image' ) ) { ?>		            
				<?php echo wp_kses_post($getimg);?>  
			<?php }else{?> 	
			<?php if ( $final_icon_image_url ): ?>
				<img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon">
			<?php else: ?>
				<i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i>
			<?php endif ?>
			<?php } ?>
		</div>
		<div class="item-content">
			<<?php echo esc_html( $data['title_tag'] );?> class="item-title"> <?php echo wp_kses_post( $title );?> <?php  if ( $data['show_post_count'] == "yes" && $data['post_count'] )  { ?><span>(<?php echo wp_kses_post( $data['post_count'] );?>)</span><?php } ?></<?php echo esc_html( $data['title_tag'] );?>>
		</div>
	</div>  
</div>