<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$final_icon       = " fas fa-thumbs-up";
$final_icon_image_url   = '';
if ( is_string( $icon['value'] ) && $dynamic_icon =  $icon['value']  ) {
  $final_icon     = $dynamic_icon;
}
if ( is_array( $icon['value'] ) ) {
  $final_icon_image_url = $icon['value']['url'];
}

?>
<div class="progress-box-layout1  progress-box-style">
    <div class="progress-content">
        <div class="item-icon">
			<?php if ( $data['icontype'] == 'image' ): ?>
    			<?php
        			if ( !empty( $data['image']['id'] ) ) {
        				echo wp_get_attachment_image( $data['image']['id'], 'full', true );
        			}
    			?>
			<?php else: ?>		
                <?php if ( $final_icon_image_url ): ?>
                <img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon">
                <?php else: ?>
                <i class="<?php  echo esc_attr( $final_icon ); ?>"></i>
                <?php endif ?>
			<?php endif; ?>
        </div>
        <div class="item-content">
        	  <div class="count-number rt-el-counter rtin-counter counting-text counter">
        	  	<span class="rt-counter-num" data-num="<?php echo esc_attr( $data['number'] );?>" data-rtspeed="<?php echo esc_attr( $data['speed'] );?>" data-rtsteps="<?php echo esc_attr( $data['steps'] );?>">
        	  		<?php echo esc_html( $data['number'] );?>        	  			
        	  		</span>
        	  		<?php echo esc_html( $data['suffix'] );?>
        	  	</div>
            <div class="count-title"><?php echo wp_kses_post( $data['title'] );?></div>
        </div>
    </div>
</div>