<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\fmwave\Helper;

$rdtheme_light_logo = empty( Helper::rt_the_logo_light() ) ? get_bloginfo( 'name' ) : Helper::rt_the_logo_light();
?>
<!-- Coming Soon -->
<section class="coming-soon">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-7">
                <div class="content-wrap">
                    <div class="item-logo">
	                    <?php if ( !empty( Helper::rt_the_logo_light() ) ){ ?>
                            <img src="<?php echo esc_url( $rdtheme_light_logo );?>" alt="<?php bloginfo( 'name' ); ?>">
	                    <?php } else { ?>
		                    <?php echo esc_html( $rdtheme_light_logo ) ; ?>
	                    <?php } ?>
                    </div>
	                <?php if( $data['title'] ){ ?><h2 class="item-title"><?php echo wp_kses_post( $data['title'] ); ?></h2><?php } ?>
	                <?php if ( !empty( $data['content'] ) ) { ?>
                        <p class="rtin-text"><?php echo wp_kses_post( $data['content'] );?></p>
	                <?php } ?>
                    <div class="input-group stylish-input-group">
                        <input type="text" class="form-control" placeholder="Your Email . . .">
                        <span class="input-group-addon">
                                    <button type="submit">
                                        Get Updates
                                    </button>
                                </span>
                    </div>

                    <ul class="social-icon">
                        <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                    </ul>

                </div>
            </div>
        </div>
        <div class="footer-copyright">Copyright © 2020 <span>Helloo!</span> by <a rel="nofollow" href="https://www.radiustheme.com/">RadiusTheme</a>.</div>
    </div>
</section>
