<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Group_Control_Image_Size;
use \WP_Query;

$prefix = FMWAVE_CORE_CPT;
 ?>
<div class="popular-chart-box">
    <div class="popular-list">
        <?php
        $args = array(
            'post_type'  => "{$prefix}_music",
            'posts_per_page' => $data['post_per_page'],
            'orderby'        => $data['orderby'],
        );

        if ( !empty( $data['category'] ) ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => "{$prefix}_music_category",
                    'field' => 'term_id',
                    'terms' => $data['category'],
                )
            );
        }
        switch ( $data['orderby'] ) {
            case 'title':
            case 'menu_order':
            case 'date':
            $args['order'] = 'ASC';
            break;
        }

        if ( !empty( $data['fm_track_ids'] ) ) {
            $args['post__in'] = array( $data['fm_track_ids'] );
        }

        $query = new WP_Query( $args );
        $temp = Helper::wp_set_temp_query( $query );

        if ($query->have_posts()) {
            while ( $query->have_posts() ) { $query->the_post();
                $get_view = get_post_meta( get_the_ID(), 'video_view' , true );
                $get_audio_length = get_post_meta( get_the_ID(), "{$prefix}_track_length" , true );
                $get_audio_track = get_post_meta( get_the_ID(), "{$prefix}_track" , true );
                $get_artist = get_post_meta( get_the_ID(), "{$prefix}_artist" , true );
                $get_release_day = get_post_meta( get_the_ID(), "{$prefix}_release_day" , true );

                $get_produce = get_post_meta( get_the_ID(), "{$prefix}_produce" , true );
        ?>
                <div class="single-music">
                    <div class="music-name">
						<?php
						$terms = get_the_terms( get_the_ID(), "{$prefix}_music_album");
						if ( $terms && ! is_wp_error( $terms ) ) {
							$draught_links = array();
							foreach ( $terms as $term ) {
								$draught_links[] = $term->name;
							}
							$albums = join( ", ", $draught_links );
						?>
                        <h3 class="item-title"><?php printf( esc_html__( '%s ', 'fmwave-core' ), esc_html( $albums ) ); ?></h3>
                        <?php } ?>
                        <div class="item-subtitle"><?php echo esc_html( $get_release_day ); esc_attr_e(' By ','fmwave-core');  echo esc_html( $get_artist ); ?></div>
                    </div>
                    <div class="music-details">
                        <div class="media">
                            <div class="item-img"><a href="<?php the_permalink(); ?>"><?php if ( has_post_thumbnail() ){ the_post_thumbnail( array(40, 40) ); }	?></a></div>
                            <div class="media-body">
                                <div class="item-heading">
                                    <h4 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> - <?php echo esc_html( $get_artist ); ?></h4>
                                </div>
                                <ul class="music-meta">
                                    <li><i class="fas fa-microphone-alt"></i><?php
										$terms = get_the_terms( get_the_ID(), "{$prefix}_music_genre");
										if ( $terms && ! is_wp_error( $terms ) ) {
											$draught_links = array();
											foreach ( $terms as $term ) {
												$draught_links[] = $term->name;
											}
											$on_term = join( ", ", $draught_links );
											?><?php printf( esc_html__( '%s ', 'fmwave-core' ), esc_html( $on_term ) ); ?>
										<?php } ?></li>
                                    <li><i class="fas fa-sliders-h"></i><?php echo esc_html( $get_produce ); ?></li>
                                    <?php if ( $data['show_count'] == 'yes' && function_exists( 'fmwave_views' ) ) { ?>
                                    <li><i class="fas fa-eye"></i><?php echo fmwave_views(); ?></li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="music-duration"><i class="far fa-clock"></i><?php echo esc_html( $get_audio_length ); ?></div>
                    <div class="rt-music-play rt-music-player-wrap">
                        <audio class="fmwave-audio-plybtn" style="display: none">
                            <source src="<?php echo wp_get_attachment_url( $get_audio_track ); ?>" type="audio/mp3">
                        </audio>
                    </div>
                </div>
        <?php }
        } else { ?>
            <div class="text-center"><?php esc_attr_e('No Audio/Track Found' , 'fmwave-core'); ?></div>
        <?php } ?>
        <?php Helper::wp_reset_temp_query( $temp );?>
    </div>
</div>
