<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Group_Control_Image_Size;
use \WP_Query;

$prefix = FMWAVE_CORE_CPT;

$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'chart_top_image' );

?>
<div class="chart-box-content">
    <?php if ( !empty( $getimg ) ) { ?>
    <div class="item-img">
        <?php echo wp_kses_post($getimg);?>
        <div class="item-content">
            <?php if ( !empty( $data['time_text'] ) ) { ?>
            <div class="item-subtitle"><?php echo esc_html( $data['time_text'] ); ?></div>
            <?php } if( !empty( $data['chart_name'] ) ) { ?>
            <h3 class="item-title"><?php echo esc_html( $data['chart_name'] ); ?></h3>
            <?php } ?>
        </div>
    </div>
    <?php } ?>
    <div class="chart-list">
        <ol>
        <?php
            $args = array(
                'post_type'  => "{$prefix}_music",
                'posts_per_page' => $data['post_per_page'],
                'orderby'        => $data['orderby'],
            );

            if ( !empty( $data['category'] ) ) {
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => "{$prefix}_music_category",
                        'field' => 'term_id',
                        'terms' => $data['category'],
                    )
                );
            }
            switch ( $data['orderby'] ) {
                case 'title':
                case 'menu_order':
                case 'date':
                $args['order'] = 'ASC';
                break;
            }

            if ( !empty( $data['fm_track_ids'] ) ) {

                $args['post__in'] = explode(',', $data['fm_track_ids']);
            }

            $query = new WP_Query( $args );
            $temp = Helper::wp_set_temp_query( $query );

            if ($query->have_posts()) {
                while ( $query->have_posts() ) { $query->the_post();
                    $get_view = get_post_meta( get_the_ID(), 'video_view' , true );
                    $get_length = get_post_meta( get_the_ID(), "{$prefix}_video_length" , true );
                    $get_video_link = get_post_meta( get_the_ID(), "{$prefix}_video_link" , true );
					$get_audio_track = get_post_meta( get_the_ID(), "{$prefix}_track" , true );
                    $get_artist = get_post_meta( get_the_ID(), "{$prefix}_artist" , true );

                    $total_view = (int) get_post_meta( get_the_ID(), 'post_view_count', true );
                    ?>
                <li class="audio-container">
                    <h3 class="item-song">
                        <?php if ( has_post_thumbnail() ){ the_post_thumbnail( 'full' ); }	?>
                        <?php 
                            $class_name = ( $total_view >= 10 ) ? 'up' : 'down';
                        ?>
                        <i class="fas fa-caret-<?php echo esc_attr($class_name); ?> text-malachite"></i><?php the_title(); ?> - <span><?php echo esc_html( $get_artist ); ?></span>
                    </h3>
                    <div class="hover-content">
                        <div class="media">
                            <div class="item-img"><?php if ( has_post_thumbnail() ){ the_post_thumbnail( 'full' ); } ?></div>
                            <div class="media-body">
                                <h3 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                <div class="item-action" data-post-id="<?php echo esc_attr( get_the_ID() ); ?>"><audio  class="fmwave-audio-plybtn" ><source src="<?php echo wp_get_attachment_url( $get_audio_track ); ?>" type="audio/mp3"></audio></div>
                                <ul class="item-meta">
                                    <li>
                                        <i class="flaticon-worker"></i>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </li>
                <?php }
            } else { ?>
                <div class="text-center"><?php esc_attr_e('No Video Found' , 'fmwave-core'); ?></div>
            <?php } ?>
            <?php Helper::wp_reset_temp_query( $temp );?>

        </ol>

    </div>

</div>
